/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_QueryInt.cc       ULTIMA MODIFICA: 16/07/1999        */
/*                                                                  */
/*  Implementazione della classe QueryInt. (op=8)                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


QueryInt::QueryInt() {
    classname="QueryInt";
    titpagine="Query ad uso interno";   // non verra` mai visualizzato...
    risp="QueryInt non ha ancora risposto";
    initialized=0;
}


void QueryInt::type1(stringone* strngn) {
    char* buff;
    char minibuf[2];
    minibuf[1]='\0';

    // determina su quale lettera si deve eseguire la query
    buff=check_keytoken(strngn,"letter");
    if(buff!=NULL) minibuf[0]=buff[0]; else return;
    
    risp+=big_title(minibuf);

    // esegue una query per avere una lista dei corrispondenti per cui
    // Denominaz1 inizia con la lettera specificata
    SqlResult* R;
    int i, imax, j;
    try { R=connection->queryPerLettera(minibuf); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query per lettera fallita");
	return;
    }
    imax=R->rowNum();

    // se tutto e` andato bene, si puo` cominciare a costruire la pagina HTML
    if(imax==0) {
        risp+="Non c' alcun corrispondente che inizi con questa lettera.\n";
        return;
    }
    risp+="<SCRIPT LANGUAGE=\"javascript\">\n";
    risp+"<!--\n";
    risp+="function cambia_codiceca(codice) {\n";
    risp+="    parent.Frame1.document.modulo.codiceca.value=codice;\n";
    risp+="}\n";
    risp+="// -->\n";
    risp+="</SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";

    risp+="<FORM NAME=\"corrispondenti\">\n";
    risp+="<TABLE border=\"1\" cellspacing=\"0\" width=\"100%\">\n";
    risp+="<TR ALIGN=\"center\">\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Codice</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Denominaz1</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Denominaz2</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Indirizzo</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Citt</STRONG></FONT></TD>\n";
    risp+="</TR>\n";
    for(i=0;i<imax;++i) {
        risp+="<TR ALIGN=\"center\">\n";
        risp=risp+"    <TD><INPUT TYPE=BUTTON VALUE="+R->get(i,0)
             +" onClick=\"cambia_codiceca('"+R->get(i,0)+"')\"></TD>\n";
        for(j=1;j<5;++j) risp=risp+"    <TD>"+fn(R->get(i,j))+"</TD>\n";
        risp+="</TR>\n";
    }
    risp+="</TABLE>\n";
    risp+="</FORM>\n";
    risp+="</FONT>\n";
}


void QueryInt::type2(stringone* strngn) {
    char* buff;
    char minibuf[2];
    minibuf[1]='\0';

    // determina su quale lettera si deve eseguire la query
    buff=check_keytoken(strngn,"letter");
    if(buff!=NULL) minibuf[0]=buff[0]; else return;

    risp+=big_title(minibuf);
    
    // esegue una query per avere una lista dei c/a/d per cui
    // Denominaz1 inizia con la lettera specificata
    SqlResult* R;
    int i, imax, j;
    try { R=connection->queryPerLetteraTipo(minibuf); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query per lettera dei c/a/d fallita");
	return;
    }
    imax=R->rowNum();

    // se tutto e` andato bene, si puo` cominciare a costruire la pagina HTML
    if(imax==0) {
        risp+="Non c' alcun corrispondente, affidatario o dipendente che inizi con questa lettera.\n";
        return;
    }
    risp+="<SCRIPT LANGUAGE=\"javascript\">\n";
    risp+"<!--\n";
    risp+="function cambia_codiceca(codice) {\n";
    risp+="    parent.Frame1.document.modulo.codiceca.value=codice;\n";
    risp+="}\n";
    risp+="// -->\n";
    risp+="</SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";

    risp+="<FORM NAME=\"c_a_d\">\n";
    risp+="<TABLE border=\"1\" cellspacing=\"0\" width=\"100%\">\n";
    risp+="<TR ALIGN=\"center\">\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Codice</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Denominaz1</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Denominaz2</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Indirizzo</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Citt</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Tipo</STRONG></FONT></TD>\n";
    risp+="</TR>\n";
    for(i=0;i<imax;++i) {
        risp+="<TR ALIGN=\"center\">\n";
        risp=risp+"    <TD><INPUT TYPE=BUTTON VALUE="+R->get(i,0)
             +" onClick=\"cambia_codiceca('"+R->get(i,0)+"')\"></TD>\n";
        for(j=1;j<6;++j) risp=risp+"    <TD>"+fn(R->get(i,j))+"</TD>\n";
        risp+="</TR>\n";
    }
    risp+="</TABLE>\n";
    risp+="</FORM>\n";
    risp+="</FONT>\n";
}


String& QueryInt::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>QueryInt:la classe non  stata inizializzata.</BODY>\n";
	return risp;
    }
    
    // stampa l'intestazione
    risp=beginbody();

    // decide il da farsi in base al token "type"
    char* buff=check_keytoken(strngn,"type");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
	case 1:
	    type1(strngn);  // query per lettera dei soli corrispondenti
	break;
	case 2:
	    type2(strngn);  // query per lettera di corrisp., affidatari e dipendenti
	break;
	default:
	    risp+="QueryInt: contenuto del token 'type' non valido.<BR>\n";
	break;
    }        

    risp+=endbody();
    return risp;
}


void QueryInt::reset() {
    initialized=0;
}
