/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_QuerySimple.cc    ULTIMA MODIFICA: 13/09/1999        */
/*                                                                  */
/*  Implementazione della classe QuerySimple. (op=10)               */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


QuerySimple::QuerySimple() {
    classname="QuerySimple";
    titpagine="Query semplici";   // non verra` mai visualizzato...
    risp="QuerySimple non ha ancora risposto";
    initialized=0;
}


void QuerySimple::init(int id, SqlConnection* c) {
    userid=id;
    connection=c;

    aut_lettura=connection->autorizzato_lettura();
    aut_inserimento=connection->autorizzato_inserimento();
    aut_modifica=connection->autorizzato_modifica();
    aut_cancellazione=connection->autorizzato_cancellazione();

    reset();        // inizializza le variabili ai valori predefiniti
    
    initialized=1;
}


void QuerySimple::StampaCarta(stringone* strngn) {
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"anno\");\n";
    risp+="    var reqFieldsNames=new Array(\"Anno\");\n";
    risp+="    var numFields=new Array(\"anno\");\n";
    risp+="    var numFieldsNames=new Array(\"Anno\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    // determina l'anno in cui cercare i documenti
    char* buff;
    buff=check_token(strngn,"anno");
    if(buff!=NULL) anno=buff; else anno=annocorr();
    
    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=10>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=1>\n";
    risp=risp+"    <FONT FACE=\"Helvetica\" SIZE=+2><STRONG>\n";
    risp=risp+"    Documenti registrati nel corso dell'anno ";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"anno\"  VALUE=\""+anno.html()
         +"\" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"</STRONG></FONT>\n</FORM>\n";

    // ricerca separatamente carichi e scarichi arrivati nel corso dell'anno
    SqlResult R1, *R2;
    try {
        R2=connection->queryOutCartaCarico(anno);
        R1=*R2;
        R2=connection->queryOutCartaScarico(anno);
    }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "fallita la query dei carichi (o degli scarichi)");
	return;
    }
    int i1, i1max, i2, i2max, k;
    SqlInt *n1, *n2;
    // costruisce una tabella facendo il merge dei risultati delle
    // due ricerche
    i1max=R1.rowNum();
    i2max=R2->rowNum();
    risp+="<FONT FACE=\"Times\">\n";
    if((i1max==0)&&(i2max==0)) {
        risp+="Nessun documento trovato.<BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="<BR>Torna al menu</A><BR>\n";
        risp+="</FONT>\n";
        return;
    }
    risp+="<TABLE BORDER=1 CELLSPACING=0 WIDTH=100%>\n";
    risp+="<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>NUMERO di protocollo</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>TIPO dell'atto</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>DATA dell'arrivo o della partenza</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>CORRISPONDENTE (organizz. o persona)</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>DATA o numero dell'atto</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>RIPARTO al quale l'atto  assegnato</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>OGGETTO</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Annotazioni</STRONG></FONT></TD>\n</TR>\n";
    n1=new SqlInt[i1max+1];
    n2=new SqlInt[i2max+1];
    for(k=0; k<i1max; k++) n1[k]=R1.get(k,0);
    for(k=0; k<i2max; k++) n2[k]=R2->get(k,0);
    n1[i1max]=((int)(((unsigned int)-1)>>1));   // massimo intero positivo
    n2[i2max]=n1[i1max];
    i1=0;
    i2=0;
    while((i1<i1max)||(i2<i2max)) {
        risp+="<TR>\n";
	if(n1[i1]<=n2[i2]) {
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R1.get(i1,0))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">carico</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R1.get(i1,1))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R1.get(i1,3))
	             +" "+fn2(R1.get(i1,4))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R1.get(i1,5))
	             +" "+fn(R1.get(i1,6))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R1.get(i1,7))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R1.get(i1,2))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">-</TD>\n";
	    i1++;
	} else {
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R2->get(i2,0))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">scarico</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R2->get(i2,1))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R2->get(i2,3))
	             +" "+fn2(R2->get(i2,4))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">-</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R2->get(i2,5))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R2->get(i2,2))+"</TD>\n";
	    risp=risp+"    <TD ALIGN=\"center\">"+fn(R2->get(i2,6))+"</TD>\n";
	    i2++;
	}
        risp+="</TR>\n";
    }
    risp+="</TABLE><BR>\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
    delete[] n1;
    delete[] n2;
}


void QuerySimple::RicScarichi(stringone* strngn) {
    char* buff;
    String s;
    SqlInt annopadre, numpadre;
    
    // determina anno e numero del documento padre in base al contenuto
    // dei token nello stringone
    buff=check_keytoken(strngn,"annopadre");
    if(buff!=NULL) annopadre=buff; else return;
    buff=check_keytoken(strngn,"numpadre");
    if(buff!=NULL) numpadre=buff; else return;

    // A questo punto, possiamo stampare il titolo
    s="Risposte al documento n. ";
    s=s+numpadre+" del "+annopadre;
    risp+=big_title(s);
    
    // esegue una query per determinare i documenti inviati in risposta
    // al documento padre
    SqlResult* R;
    try { R=connection->queryCorrispondenza(annopadre, numpadre); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query delle risposte fallita");
	return;
    }
    
    // stampa i risultati della query in una tabella
    int i, imax, j;
    imax=R->rowNum();
    risp=risp+imax+" documenti trovati.<BR><BR>\n";
    risp+="<FONT FACE=\"Times\">\n";
    risp+="<TABLE BORDER=1 CELLSPACING=0 WIDTH=100%>\n";
    risp+="<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Anno</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Numero</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Oggetto</STRONG></FONT></TD>\n</TR>\n";
    for(i=0; i<imax; ++i) {
        risp+="<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
        for(j=0; j<3; ++j) risp=risp+"    <TD>"+fn(R->get(i,j))+"</TD>\n";
	risp=risp+"<TD><FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\">\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=10>\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=4>\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"annodoc\" VALUE="+R->get(i,0)+">\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"numdoc\" VALUE="+R->get(i,1)+">\n";
        risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Mostra\">\n";
	risp=risp+"</FORM></TD>\n";
        risp+="<TR>\n";
    }
    risp+="</TABLE><BR>\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


void QuerySimple::RicCarico(stringone* strngn) {
    char* buff;
    SqlInt annofiglio, numfiglio;
    
    // determina anno e numero del documento di cui determinare
    // il padre in base al contenuto dei token nello stringone
    buff=check_keytoken(strngn,"annofiglio");
    if(buff!=NULL) annofiglio=buff; else return;
    buff=check_keytoken(strngn,"numfiglio");
    if(buff!=NULL) numfiglio=buff; else return;

    // A questo punto, si puo` eseguire la query
    SqlResult* R;
    try { R=connection->queryPadreScarico(annofiglio, numfiglio); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query del documento padre fallita");
	return;
    }
    
    // stampa i risultati della ricerca; e` un semplice rimbalzo
    // a InfoDoc (op=10,type=4)
    // UGLY: forse c'e` un modo piu` semplice di fare questa cosa
    risp+="<SCRIPT LANGUAGE=\"javascript\">\n";
    risp+="<!--\n";
    risp+="function salta(url) {self.location=url;}\n";
    risp+="// -->\n";
    risp+="</SCRIPT>\n";
    risp=risp+"<BODY ONLOAD=\"salta('"+BRIDGE_PATH+"?userid="+userid
         +"&op=10&type=4&annodoc="+R->get(0,0)+"&numdoc="+R->get(0,1)+"')\"></BODY>\n";
}


void QuerySimple::InfoDoc(stringone* strngn) {
    char* buff;
    String s;
    SqlInt annodoc, numdoc;
    
    // determina anno e numero del documento da cercare in base
    // al contenuto dei token nello stringone
    buff=check_keytoken(strngn,"annodoc");
    if(buff!=NULL) annodoc=buff; else return;
    buff=check_keytoken(strngn,"numdoc");
    if(buff!=NULL) numdoc=buff; else return;

    // A questo punto, possiamo stampare il titolo
    s="Informazioni sul documento n. ";
    s=s+numdoc+" del "+annodoc;
    risp+=big_title(s);
    risp+="<FONT FACE=\"Times\">\n";
    
    // esegue una query per determinare le informazioni sul documento
    SqlResult* R;
    int imax;
    String tipodoc="carico";
    bool conrisposte,    // ha senso solo per un carico
         risposta,       // ha senso solo per uno scarico
	 affidato;       // ha senso per tutti e 2
    try {
        // cerca prima il documento tra i carichi
        R=connection->queryInfoCarico(annodoc, numdoc);
	imax=R->rowNum();
	
	// se non lo trova, allora lo cerca tra gli scarichi
        if(imax==0) {
            R=connection->queryInfoScarico(annodoc, numdoc);
	    imax=R->rowNum();
	    tipodoc="scarico";
	}

        // se ancora non lo trova, allora stampa un mess. d'errore ed esce
        if(imax==0) {
            risp+=errore("Documento non trovato",
	          "la ricerca delle informazioni sul documento  fallita");
            return;
	}

        // esegue alcune query aggiuntive
	if(tipodoc=="carico") {
	    conrisposte=connection->queryEsisteScaricoAssociato(annodoc, numdoc);
            risposta=0;
	} else {
	    conrisposte=0;
	    risposta=connection->queryEsisteCaricoAssociato(annodoc, numdoc);
	}
	affidato=connection->queryEsisteAffidamento(annodoc, numdoc);
    }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query del documento fallita");
	return;
    }

    // controlla il numero di documenti trovati: se ce n'e` piu` di uno,
    // stampa un warning
    if(imax>1) {
        risp+="Esiste pi di un documento con l'anno e il numero di protocollo";
	risp+="specificati: stamper le informazioni solo sul primo di questi.<BR>\n";
    }
    
    // stampa i risultati della ricerca
    risp=risp+"<STRONG>Data:</STRONG> "+fn2(R->get(0,1))+"<BR>\n";
    risp=risp+"<STRONG>Oggetto:</STRONG> "+fn2(R->get(0,2))+"<BR>\n";
    risp=risp+"<STRONG>Categoria documento:</STRONG> "+tipodoc+"<BR>\n";
    risp=risp+"<STRONG>Tipo documento:</STRONG> "+fn2(R->get(0,3))+"<BR>\n";
    risp=risp+"<STRONG>Riparto:</STRONG> "+fn2(R->get(0,4))+"<BR>\n";
    if(tipodoc=="carico") {
        risp=risp+"<STRONG>Mittente:</STRONG> "+fn2(R->get(0,5))+" "+fn2(R->get(0,6))+"<BR>\n";
        risp=risp+"<STRONG>Data sull'atto:</STRONG> "+fn2(R->get(0,7))+"<BR>\n";
        risp=risp+"<STRONG>Numero sull'atto:</STRONG> "+fn2(R->get(0,8))+"<BR>\n";
        risp=risp+"<STRONG>Data del FAX di preavviso:</STRONG> "+fn2(R->get(0,9))+"<BR>\n";
        risp=risp+"<STRONG>Esistono risposte a questo documento:</STRONG> ";
	if(conrisposte) risp+="si<BR>\n"; else risp+="no<BR>\n";
    } else {
        risp=risp+"<STRONG>Destinatario:</STRONG> "+fn2(R->get(0,5))+" "+fn2(R->get(0,6))+"<BR>\n";
        risp=risp+"<STRONG>Annotazioni:</STRONG> "+fn2(R->get(0,7))+"<BR>\n";
        risp=risp+"<STRONG>Il documento  una risposta a un carico:</STRONG> ";
	if(risposta) risp+="si<BR>\n"; else risp+="no<BR>\n";
    }
    risp=risp+"<STRONG>Il documento  attualmente in prestito:</STRONG> ";
    if(affidato) risp+="si<BR>\n"; else risp+="no<BR>\n";
    risp+="<BR>\n";
        
    // in base ai risultati della ricerca e alle autorizzazioni dell'utente,
    // mostra una lista di operazioni che e` possibile compiere sul documento
    if(aut_lettura&&risposta)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=10&type=3&annofiglio="+annodoc+"&numfiglio="+numdoc
	     +"\">Cerca</A> il documento di cui questo  la risposta<BR>\n";
    if(aut_lettura&&conrisposte)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=10&type=2&annopadre="+annodoc+"&numpadre="+numdoc
	     +"\">Cerca</A> i documenti inviati in risposta a questo<BR>\n";
    if(aut_inserimento&&affidato)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=4&stage=2&type=rest&Anno_carico="+annodoc+"&Numero_carico="+numdoc
	     +"\">Notifica</A> l'avvenuta restituzione di questo documento<BR>\n";
    if(aut_inserimento&&(!affidato))
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=4&stage=2&type=aff&Anno_carico="+annodoc+"&Numero_carico="+numdoc
	     +"\">Affida</A> questo documento<BR>\n";
    if(aut_modifica)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=5&stage=1&Anno="+annodoc+"&numdoc="+numdoc
	     +"\">Modifica</A> le informazioni relative a questo documento<BR>\n";
    
    // il ritorno al menu c'e` sempre...
    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu principale</A><BR>\n";
    risp+="</FONT>\n";
}


void QuerySimple::InfoCA(stringone* strngn) {
    char* buff;
    String s;
    SqlInt codiceca;
    
    // determina il codice del corrisp./affid./dipend. da cercare
    // in base al contenuto del token "codiceca"
    buff=check_keytoken(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else return;

    // A questo punto, possiamo stampare il titolo
    s="Informazioni sul corrispondente/affidatario n. ";
    s=s+codiceca;
    risp+=big_title(s);
    risp+="<FONT FACE=\"Times\">\n";

    // esegue una query per determinare le informazioni sul c/a/d
    SqlResult* R;
    bool ha_carichi;
    try {
        R=connection->queryInfoCA(codiceca);
        ha_carichi=connection->querySePossiedeCarichi(codiceca);
    }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query del corrispondente/affidatario fallita");
	return;
    }

    // controlla il numero di elementi trovati: se e` maggiore di uno,
    // stampa un warning (questa situaz. non dovrebbe mai accadere!)
    if(R->rowNum()>1) {
        risp+="Esiste pi di un corrispondente, affidatario o dipendente con il codice";
	risp+="specificato: stamper le informazioni solo sul primo di questi.<BR>\n";
    }
    
    // stampa i risultati della ricerca
    risp=risp+"<STRONG>Denominaz1:</STRONG> "+fn2(R->get(0,1))+"<BR>\n";
    risp=risp+"<STRONG>Denominaz2:</STRONG> "+fn2(R->get(0,2))+"<BR>\n";
    risp=risp+"<STRONG>Tipo:</STRONG> "+fn2(R->get(0,3))+"<BR>\n";
    SqlString Tipo;
    if((R->get(0,3))!=NULL) Tipo=R->get(0,3); else Tipo=null;
    risp=risp+"<STRONG>Indirizzo:</STRONG> "+fn2(R->get(0,4))+"<BR>\n";
    risp=risp+"<STRONG>Citt:</STRONG> "+fn2(R->get(0,5))+"<BR>\n";
    risp=risp+"<STRONG>CAP:</STRONG> "+fn2(R->get(0,6))+"<BR>\n";
    risp=risp+"<STRONG>Telefono:</STRONG> "+fn2(R->get(0,7))+"<BR>\n";
    risp=risp+"<STRONG>FAX:</STRONG> "+fn2(R->get(0,8))+"<BR>\n";
    int numcol=R->colNum();
    if((Tipo=="dipendente")&&(numcol>9)) {
        risp=risp+"<STRONG>Ufficio:</STRONG> "+fn2(R->get(0,9))+"<BR>\n";
    }
    if(((Tipo=="corr_persona")||(Tipo=="aff_persona"))&&(numcol>9)) {
        risp=risp+"<STRONG>Titolo:</STRONG> "+fn2(R->get(0,9))+"<BR>\n";
        risp=risp+"<STRONG>Codice fiscale:</STRONG> "+fn2(R->get(0,10))+"<BR>\n";
    }
    if(((Tipo=="corr_org")||(Tipo=="aff_org"))&&(numcol>9)) {
        risp=risp+"<STRONG>Partita IVA:</STRONG> "+fn2(R->get(0,9))+"<BR>\n";
        risp=risp+"<STRONG>Tramite:</STRONG> "+fn2(R->get(0,10))+"<BR>\n";
    }
    risp=risp+"<STRONG>Ha attualmente in prestito dei carichi:</STRONG> ";
    if(ha_carichi) risp+="si"; else risp+="no";
    risp+="<BR>\n<BR>\n";

    // in base ai risultati della ricerca e alle autorizzazioni dell'utente,
    // mostra una lista di operazioni che e` possibile compiere
    if(aut_lettura&&ha_carichi)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=10&type=6&codiceca="+codiceca
	     +"\">Ricerca</A> i carichi affidati a costui<BR>\n";
    if(aut_modifica)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=7&stage=1&codiceca="+codiceca
	     +"\">Modifica</A> le informazioni relative a questo corrispondente/affidatario<BR>\n";
    if(aut_cancellazione)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid
	     +"&op=15&stage=1&codiceca="+codiceca
	     +"\">Cancella</A> questo corrispondente/affidatario dalla base dati<BR>\n";

    // il ritorno al menu c'e` sempre...
    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu principale</A><BR>\n";
    risp+="</FONT>\n";
}


void QuerySimple::RicAffid1(stringone* strngn) {
    char* buff;
    String s;
    SqlInt codiceca;
    
    // determina il codice del corrisp./affid./dipend. da cercare
    // in base al contenuto del token "codiceca"
    buff=check_keytoken(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else return;

    // A questo punto, possiamo stampare il titolo
    s="Carichi attualmente prestati al corrispondente/affidatario n. ";
    s=s+codiceca;
    risp+=big_title(s);
    risp+="<FONT FACE=\"Times\">\n";

    // esegue una query per determinare le informazioni sui documenti 
    // prestati al c/a/d
    bool OK=1;
    SqlResult* R;
    int i,imax,j;
    try { R=connection->queryCarichiPosseduti(codiceca); }
    catch(SqlConnection::GenericError error) {
        OK=0;
        risp+=errore(error.toString(), "query del carichi prestati fallita");
    }

    // stampa i risultati della ricerca
    if(OK) {
        imax=R->rowNum();
        risp=risp+imax+" carichi trovati.<BR><BR>\n";
        risp+="<TABLE BORDER=1 CELLSPACING=0 WIDTH=100%>\n";
        risp+="<TR  ALIGN=\"center\" VALIGN=\"middle\">\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Anno</STRONG></FONT></TD>\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Numero</STRONG></FONT></TD>\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Oggetto</STRONG></FONT></TD>\n";
        risp+="    <TD></TD>\n</TR>\n";
        for(i=0;i<imax;++i) {
            risp+="<TR  ALIGN=\"center\" VALIGN=\"middle\">\n";
	    for(j=0;j<3;++j) {
	        risp=risp+"<TD>";
		if(R->get(i,j)!=NULL) risp+=R->get(i,j); else risp+="<EM>null</EM>";
		risp+="</TD>\n";
	    }
	    risp=risp+"<TD><FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=10>\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=4>\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"annodoc\" VALUE="+R->get(i,0)+">\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"numdoc\" VALUE="+R->get(i,1)+">\n";
            risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Mostra\">\n";
	    risp=risp+"</FORM></TD>\n";
	    risp+="</TR>\n";
	}
	risp=risp+"</TABLE>\n";
        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=10&type=5";
	risp=risp+"&codiceca="+codiceca+"\">Torna alla pagina precedente</A>\n";
    }
    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


void QuerySimple::RicAffidTutti() {
    // stampa il titolo
    risp+=big_title("Documenti prestati e non restituiti");

    // esegue la ricerca
    SqlResult* R;
    try { R=connection->queryAffidamentoFuori(); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "la query dei documenti non restituiti  fallita");
	return;
    }
    
    // stampa i risultati della ricerca
    int i, imax, j;
    imax=R->rowNum();
    risp=risp+imax+" documenti trovati.<BR><BR>\n";
    risp+="<FONT FACE=\"Times\">\n";
    risp+="<TABLE BORDER=1 CELLSPACING=0 WIDTH=100%>\n";
    risp+="<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Anno</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Numero</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Oggetto</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Denominaz1</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Denominaz2</STRONG></FONT></TD>\n";
    risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
    risp+="        <STRONG>Data affidamento</STRONG></FONT></TD>\n</TR>\n";
    for(i=0; i<imax; ++i) {
        risp+="<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
        for(j=0; j<6; ++j) risp=risp+"    <TD>"+fn(R->get(i,j))+"</TD>\n";
	risp=risp+"<TD><FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\">\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=10>\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=4>\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"annodoc\" VALUE="+R->get(i,0)+">\n";
        risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"numdoc\" VALUE="+R->get(i,1)+">\n";
        risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Mostra\">\n";
	risp=risp+"</FORM></TD>\n";
        risp+="<TR>\n";
    }
    risp+="</TABLE><BR>\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


String& QuerySimple::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>QuerySimple:la classe non  stata inizializzata.</BODY>\n";
	return risp;
    }
    
    // stampa l'intestazione
    risp=beginbody();

    // decide il da farsi in base al token "type"
    char* buff=check_keytoken(strngn,"type");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
	case 1:
	    StampaCarta(strngn);// stampa conforme al protocollo cartaceo
	break;
	case 2:
	    RicScarichi(strngn);// ricerca degli scarichi associati a un certo carico
	break;
	case 3:
	    RicCarico(strngn);  // informaz. sul documento "padre" di un dato scarico
	break;
	case 4:
	    InfoDoc(strngn);    // tutte le informazioni su un documento
	break;
	case 5:
	    InfoCA(strngn);     // tutte le informazioni su un corrisp./affid./dipend.
	break;
	case 6:
	    RicAffid1(strngn);  // lista dei documenti affidati a un c/a/d e non restituiti
	break;
	case 7:
	    RicAffidTutti();    // lista di tutti i documenti affidati e non restituiti
	break;
	default:
	    risp+="QuerySimple: contenuto del token 'type' non valido.<BR>\n";
	break;
    }        

    risp+=endbody();
    return risp;
}


void QuerySimple::reset() {
    anno=annocorr();
}
