/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_Restore.cc         ULTIMA MODIFICA: 30/09/1999       */
/*                                                                  */
/*  Implementazione della classe Restore. (op=16)                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "exception.h"
#include "html_utils.h"
#include "sys/stat.h"


Restore::Restore() {
    classname="Restore";
    titpagine="Recupero del database da dischetti";
    risp="Restore non ha ancora risposto";
    initialized=0;
}


void Restore::init(int id, SqlConnection* c) {
    userid=id;
    connection=c;

    initialized=1;
}


FILE* Restore::startRestore() {
    part = 1;
    return fopen("/tmp/cherubino.dat.gz", "wb");
}


bool Restore::copyLoad(FILE* hardFile) {
    FILE* floppyFile;
    String command;
    String fileName = "monk"+String(part)+".db";
    int byteToRead = 1024*1400;
    char* buffer = new char[byteToRead];
    
#ifdef __CYGWIN__
    command = "cp a:monk" + String(part) + ".gz /tmp/monk.spt";
#else
    command = "mcopy a:monk" + String(part) + ".gz /tmp/monk.spt ";
#endif
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    floppyFile = fopen("/tmp/monk.spt", "rb");
    if (floppyFile == NULL) throwException(Error("opening /tmp/monk.spt"));

    int remain = 1;
    fread(&remain, 1, sizeof(remain), floppyFile);
    int bytesReaden = fread(buffer, 1, byteToRead, floppyFile);
    fwrite(buffer, 1, bytesReaden, hardFile);
    delete[] buffer;
    fclose(floppyFile);

    ++part;
    return false; //(remain != 0);
}

void Restore::endRestore() {

#ifdef __CYGWIN__
    String command = "echo drop table SCARICO_INFO_OPZ | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table SCARICO | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table CORRISPONDENZA | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table RIPARTO | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table CARICO | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table AFFIDAMENTO | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table CORRISPONDENTE_AFFIDATARIO | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table CORRISP_ORGANIZZAZIONE | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table CORRISP_PERSONA | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table DIPENDENTE_INFO | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "echo drop table OPERAZIONE | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

#else

    String command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table SCARICO_INFO_OPZ' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table SCARICO' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));
        
    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table CORRISPONDENZA' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table RIPARTO' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table CARICO' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table AFFIDAMENTO' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table CORRISPONDENTE_AFFIDATARIO' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table CORRISP_ORGANIZZAZIONE' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table CORRISP_PERSONA' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table DIPENDENTE_INFO_AGG' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

    command = "mysql -u " + userName + " --password=" + userPwd + 
            " --execute='drop table OPERAZIONE' cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));
#endif

    system("rm /tmp/cherubino.dat");
    system("gzip -f -d /tmp/cherubino.dat.gz");        
    
    command = "cat /tmp/cherubino.dat | mysql -u " + userName + " --password=" + userPwd + 
            " cherubino";
    if (system(command.cString()) != 0) throwException(Error("executing "+command));

}

void Restore::stage0_process(stringone* strngn) {
    hardFile = startRestore();
    stage1_showpage();
}


void Restore::stage1_showpage() {
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="function salta(url) { self.location=url; }\n";
    risp+="// --></SCRIPT>\n";
    
    risp+="<FONT FACE=\"Times\">\n";
    risp+="L'operazione di restore permette di recuperare da dischetti l'intero\n";
    risp+="contenuto del database.<BR>\n";
    risp+="Nelle pagine seguenti verr chiesto di inserire i dischetti.<BR>\n";
    risp+="Il tempo di attesa tra una schermata e l'altra  normale ed  dovuto\n";
    risp+="alla lentezza con cui i dati vengono trasferiti dal dischetto.<BR>\n";
    risp+="L'operazione di restore non pu essere effettuata in rete.<BR>\n";

    risp+="<BR><BR>\n";
    risp+="<STRONG> Inserire il dischetto "+String(part);
    risp+=" e premere il tasto \"Avanti >\"</STRONG>\n<BR><BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=16>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
}


void Restore::stage2_showpage() {
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="function salta(url) { self.location=url; }\n";
    risp+="// --></SCRIPT>\n";
    
    risp+="<FONT FACE=\"Times\">\n";
    risp+="<BR><BR>\n";
    risp+="<STRONG> Inserire il dischetto "+String(part);
    risp+=" e premere il tasto \"Avanti >\"</STRONG>\n<BR><BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=16>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
}


void Restore::stage3_showpage() {
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="function salta(url) { self.location=url; }\n";
    risp+="// --></SCRIPT>\n";
    
    risp+="<FONT FACE=\"Times\">\n";
    risp+="I dati su dischetto sono stati caricati in memoria.<BR>\n";
    risp+="Per completare il restore i dati presenti nel database verranno <BR>\n";
    risp+="eliminati e verranno sostituiti con i dati caricati da dischetto.<BR>\n";

    risp+="<BR><BR>\n";
    risp+="<STRONG>Questa operazione  pericolosa: per continuare";
    risp+=" premere il tasto \"Avanti >\"</STRONG>\n<BR><BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=16>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=4>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
}

void Restore::stage4_showpage() {
    risp+="<FONT FACE=\"Times\">\n";
    risp+="Operazione di restore completata con successo.<BR>\n";

    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


void Restore::stage1_process(stringone* strngn) {
try {
    if (copyLoad(hardFile) == true)
        stage2_showpage();
    else {
        fclose(hardFile);
        stage3_showpage();     
    }

}
    catch (Error error) {
        risp+="<FONT FACE=\"Times\">\n";
        risp+="Errore durante il restore: " + error.description() + "<BR>\n";

        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        risp+="</FONT>\n";

    }

}

void Restore::stage4_process(stringone* strngn) {
try {
    endRestore();
    stage4_showpage();
}

    catch (Error error) {
        risp+="<FONT FACE=\"Times\">\n";
        risp+="Errore durante il restore: " + error.description() + "<BR>\n";

        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        risp+="</FONT>\n";

    }


}


String& Restore::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>Restore:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }

    // stampa l'intestazione
    risp=beginbody();
    risp+=big_title(titpagine);

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage0_process(strngn);
        break;
        case 1:
            stage1_process(strngn);
        break;
        case 4:
            stage4_process(strngn);
        break;
        default:
            risp+="Restore: contenuto del token 'stage' non valido.<BR>\n";
        break;
    }        

    risp+=endbody();
    return risp;    
}


void Restore::reset() {

}
