/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: operation.cc         ULTIMA MODIFICA: 12/08/1999        */
/*                                                                  */
/*  Definizioni dei metodi della classe prototipo Operation, e      */
/*  funzioni usate da tutte le classi derivate da Operation.        */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
#include "operation.h"


// FUNZIONI USATE DA TUTTE LE CLASSI DERIVATE DA Operation

// restituisce l'anno corrente
SqlInt annocorr() {
   time_t tempo_in_secondi;
   struct tm *tempo;
   SqlInt Anno;

   // chiede al sistema il numero di secondi trascorsi dall'1/1/1970
   tempo_in_secondi=time(NULL);
   
   // converte questo numero in una data sensata
   tempo=localtime(&tempo_in_secondi);
   
   // restituisce l'anno
   Anno=tempo->tm_year+1900;
   return(Anno);
}

// restituisce la data corrente (cioe' la data al momento della chiamata)
SqlDate datacorr() {
   time_t tempo_in_secondi;
   struct tm *tempo;
   char stringadata[16];

   // chiede al sistema il numero di secondi trascorsi dall'1/1/1970
   tempo_in_secondi=time(NULL);
   
   // converte questo numero in una data sensata
   tempo=localtime(&tempo_in_secondi);
   
   // restituisce la data corrente nella forma gg/mm/aaaa
   sprintf(stringadata, "%d/%d/%d", tempo->tm_mday, tempo->tm_mon+1,
           tempo->tm_year+1900);

   return(SqlDate(stringadata));
}

// restituisce una stringa con il codice Javascript "standard" comune
// a tutte le pagine HTML con form
String javascript_standard(){
    return
"<SCRIPT LANGUAGE=\"javascript\">\
<!--\n\
function cambia_direz(form,d) { form.direz.value=d; }\n\
\n\
function cambia_tipo(form,d) { form.type.value=d; }\n\
\n\
function salta(url) { self.location=url; }\n\
\n\
function salta2(url) { parent.location=url; }\n\
\n\
// la seguente funzione e' basata su codice originariamente scritto\n\
// da Telecom Italia Net (TIN)\n\
function data_OK(d) {\n\
    if(d==\"\") return true;\n\
\n\
    if(d.length>10) return false;\n\
\n\
    var numsbarre=0;\n\
    var psbarra=new Array;\n\
    var ch=\'\';\n\
    for(i=0;i<d.length;i++) {\n\
        ch=d.charAt(i);\n\
        if(ch!='/' && (ch<'0')||(ch>'9')) return false;\n\
	if(ch=='/') { numsbarre++; psbarra[numsbarre]=i; }\n\
    }\n\
    if(numsbarre!=2) return false;\n\
\n\
    var giorno=d.substring(0,psbarra[1]);\n\
    if (giorno<1 || giorno>31) return false;\n\
    var mese=d.substring(psbarra[1]+1,psbarra[2]);\n\
    if (mese<1 || mese>12) return false;\n\
\n\
    return true;\n\
}\n\
\n\
// la seguente funzione e' basata su codice originariamente scritto\n\
// da Robert W. Husted della Netscape Communications Corporation\n\
function valida(form) {\n\
    var i=0;\n\
    var j=0;\n\
    var tmp=\"\";\n\
    var messErrore=\"\";\n\
    var OK=true;\n\
\n\
    // Controlla che i campi obbligatori contengano qualcosa\n\
    messErrore=\"\\nI seguenti campi non possono essere vuoti:\\n\\n\\t\";\n\
    for(i=0; i<reqFields.length; i++) {\n\
        if((form.elements[reqFields[i]].value==\"\")||(form.elements[reqFields[i]].value==\" \")) {\n\
            messErrore+=reqFieldsNames[i]+\"\\n\\t\";\n\
            OK=false;\n\
        }\n\
    }\n\
\n\
    // Se ha gia` trovato qualche errore, lo restituisce subito ed esce\n\
    if(OK == false) {\n\
        alert(messErrore);\n\
        return false;\n\
    }\n\
\n\
    // Se i campi obbligatori contengono tutti qualcosa, allora passa a\n\
    // controllare i campi che devono contenere numeri\n\
    messErrore=\"\\nI seguenti campi devono contenere numeri interi:\\n\\n\\t\";\n\
    for(i=0; i<numFields.length; i++) {\n\
        tmp=form.elements[numFields[i]].value;\n\
        // Controlla la stringa carattere per carattere\n\
        for(j=0; j<tmp.length; j++) {\n\
            ch=tmp.charAt(j);\n\
            if((ch<\"0\")||(ch>\"9\")) {\n\
                messErrore+=numFieldsNames[i]+\"\\n\\t\";\n\
                OK=false;\n\
                break;\n\
            }\n\
        }\n\
    }\n\
\n\
    // Se ha trovato qualche errore, lo restituisce subito ed esce\n\
    if(OK == false) {\n\
        alert(messErrore);\n\
        return false;\n\
    }\n\
\n\
    // Infine, controlla che i campi data contengano una data valida\n\
    messErrore=\"\\nI seguenti campi non contengono una data valida:\\n\\n\\t\";\n\
    for(i=0; i<dateFields.length; i++) {\n\
        if(data_OK(form.elements[dateFields[i]].value)==false) {\n\
            messErrore+=dateFieldsNames[i]+\"\\n\\t\";\n\
            OK=false;\n\
        }\n\
    }\n\
\n\
    // Risultato finale di tutti i controlli\n\
    if (OK == true) return true;\n\
    else {\n\
        alert(messErrore);\n\
        return false;\n\
    }\n\
}\n\
// -->\
</SCRIPT>\n";
}

// DEFINIZIONE DI ALCUNI METODI DELLA CLASSE Operation

// Inizializzazione "standard"
void Operation::init(int id, SqlConnection* c) {
    userid=id;
    connection=c;

    reset();        // inizializza le variabili ai valori predefiniti
    
    initialized=1;
}

char* Operation::check_keytoken(stringone* s, char* nometoken) {
    char* buf=s->findtoken(nometoken);
    if(buf==NULL) {
        risp=risp+classname+": il token '"+nometoken+"' non esiste.<BR><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        return NULL;
    }
    if(strlen(buf)==0) {
        risp=risp+classname+": il token '"+nometoken+"' non pu essere vuoto.<BR><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        return NULL;
    }
    return buf;
}

char* Operation::check_token(stringone* s, char* nometoken) {
    char* buf=s->findtoken(nometoken);
    if(buf==NULL) return NULL;
    if(strlen(buf)==0) return NULL;
    return buf;
}

String Operation::errore(String mess_errore, String spiegazione) {
    String s=classname;
    s=s+": "+spiegazione+".<BR>\n";
    s=s+"Si  verificato il seguente errore:<BR>\n<PRE>\n";
    s=s+mess_errore+"\n</PRE>\n";
    return(s);
}
