/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: operation.h          ULTIMA MODIFICA: 08/07/2000        */
/*                                                                  */
/*  Dichiarazioni di TUTTE le classi che gestiscono le operazioni   */
/*  di inserimento, cancellazione, modifica, query; le              */
/*  implementazioni delle varie classi si trovano invece in file    */
/*  separati.                                                       */
/*                                                                  */
/*------------------------------------------------------------------*/

#ifndef _OPERATION_H_
#define _OPERATION_H_

#include "stringone.h"
#include "sqltypes.h"
#include "sqlconnection.h"
#include "finder.h"
#include "exception.h"
#include "stdio.h"

#define BRIDGE_PATH "/cgi-bin/bridge.exe"
#define HTML_PATH   "http://localhost"

extern String userName;
extern String userPwd;

// FUNZIONI USATE DA TUTTE LE CLASSI DERIVATE DA Operation

// la seguente funzioncina intercetta i NULL trasformandoli in un trattino
inline char* fn(char* c) {
    if(c!=NULL) return c; else return "-";
}

// la seguente funzioncina intercetta i NULL trasformandoli in uno spazio
inline char* fn2(char* c) {
    if(c!=NULL) return c; else return " ";
}

// restituisce l'anno corrente
SqlInt annocorr();

// restituisce la data corrente (cioe' la data al momento della chiamata)
SqlDate datacorr();

// restituisce una stringa con il codice Javascript "standard" comune
// a tutte le pagine HTML con form
String javascript_standard();


// LA CLASSE Operation, MODELLO DI TUTTE LE CLASSI
class Operation {
public:
    virtual ~Operation() {}

    virtual void init(int id, SqlConnection* c);	
    virtual String& process(stringone* strngn) = 0;
    virtual void reset() {}

    // il seguente metodo serve per controllare che i token davvero
    // importanti esistano e contengano qualcosa; si incarica anche di
    // stampare i messaggi di errore
    char* check_keytoken(stringone* s, char* nometoken);

    // il seguente metodo serve per controllare che i token meno
    // importanti esistano e contengano qualcosa; si lascia all'utente
    // la decisione di stampare un eventuale messaggio d'errore
    char* check_token(stringone* s, char* nometoken);

    // il seguente metodo restituisce una stringa contenente il messaggio
    // d'errore e la spiegazione passati come parametri
    String errore(String mess_errore, String spiegazione);
    
    String risp;	// stringa per le risposte

protected:
    String classname;   // nome della classe
    String titpagine;   // titolo delle pagine prodotte dalla classe
    bool initialized;   // per sapere se la classe e` stata inizializzata
    int userid;         // identificativo dell'utente
    SqlConnection* connection;
};


// Classe che mostra all'utente un menu delle operazioni disponibili (op=0)
class Menu: public Operation {
public:
    Menu();
    void init(int id, SqlConnection* c);	
    String& process(stringone* strngn);
	
protected:
    bool aut_lettura;
    bool aut_inserimento;
    bool aut_modifica;
    bool aut_cancellazione;
};


// Classe per l'inserimento di un nuovo documento (op=1)
class InsDoc: public Operation {
public:
    InsDoc();
    String& process(stringone* strngn);
    void reset();
	
protected:
    SqlInt Anno;
    SqlDate Ladata;
    SqlString Oggetto;
    String cat;          // categoria del documento (carico o scarico)
    SqlString Tipo_documento;
    SqlInt codiceca;     // codice del mittente o del destinatario
    SqlString Riparto;
    SqlDate Data_atto;   // solo per documenti di tipo "carico"
    SqlString Num_atto;  // solo per documenti di tipo "carico"
    SqlDate Data_fax;    // solo per documenti di tipo "carico"
    SqlInt Anno_carico;       // solo per documenti di tipo "scarico"
    SqlInt Numero_carico;     // solo per documenti di tipo "scarico"
    SqlString Annotazioni;    // solo per documenti di tipo "scarico"

    void stage1_showpage();
    void stage2_showpage();
    void stage2_showframe1();
    void stage3_showpage();
    void stage1_process(stringone* strngn);
    void stage2_process(stringone* strngn);
    void stage3_process(stringone* strngn);
};


// Classe per l'inserimento di un nuovo riparto (op=2)
class InsRip: public Operation {
public:
    InsRip();
    String& process(stringone* strngn);
    void reset();
	
protected:
    SqlString codice;
    SqlString sign;
    
    void stage1_showpage();
    void stage1_process(stringone* strngn);
};


// Classe per l'inserimento di un nuovo corrispondente/affidatario (op=3)
class InsCA: public Operation {
public:
    InsCA();
    String& process(stringone* strngn);
    void reset();
	
protected:
    SqlString Denominaz1;
    SqlString Denominaz2;
    SqlString Tipo;
    SqlString Via;
    SqlString Citta;
    SqlString Cap;
    SqlString Telefono;
    SqlString Fax;
    SqlString Titolo;    // solo per persona
    SqlString CodFisc;   // solo per persona
    SqlString Piva;      // solo per organizzazione
    SqlString Tramite;   // solo per organizzazione
    SqlString Ufficio;   // solo per dip. della biblioteca

    void stage1_showpage();
    void stage2_showpage();
    void stage1_process(stringone* strngn);
    void stage2_process(stringone* strngn);
};


// Classe per l'affidamento/restituzione di un carico (op=4)
class InsAff: public Operation {
public:
    InsAff();
    String& process(stringone* strngn);
    void reset();
	
protected:
    SqlInt Anno_carico;
    SqlInt Numero_carico;
    SqlInt codiceca;
    String type;          // tipo di operazione (affidamento o restituzione)

    void stage1_showpage();
    void stage1_showframe1();
    void stage3_showpage();
    void stage3_showframe1();
    void affida();
    void stage1_process(stringone* strngn);
    void stage2_process(stringone* strngn);
    void stage3_process(stringone* strngn);
};


// Classe per la modifica dei dati relativi a un documento (op=5)
class ModDoc: public Operation {
public:
    ModDoc();
    String& process(stringone* strngn);
    void reset();

protected:
    SqlInt Anno;
    SqlDate Ladata;
    SqlString Oggetto;
    SqlString Tipo_documento;
    SqlInt codiceca;     // codice del mittente o del destinatario
    SqlString Riparto;
    SqlDate Data_atto;   // solo per documenti di tipo "carico"
    SqlString Num_atto;  // solo per documenti di tipo "carico"
    SqlDate Data_fax;    // solo per documenti di tipo "carico"
    SqlInt Anno_carico;       // solo per documenti di tipo "scarico"
    SqlInt Numero_carico;     // solo per documenti di tipo "scarico"
    SqlString Annotazioni;    // solo per documenti di tipo "scarico"

    SqlInt numdoc;       // numero di protocollo del documento
    String cat;          // categoria del documento (carico o scarico)

    void stage1_showpage();
    void stage2_showpage();
    void stage3_showpage();
    void stage3_showframe1();
    void stage4_showpage();
    void stage1_process(stringone* strngn);
    void stage2_process(stringone* strngn);
    void stage3_process(stringone* strngn);
    void stage4_process(stringone* strngn);
};


// Classe per la modifica dei dati relativi a un riparto (op=6)
class ModRip: public Operation {
public:
    ModRip();
    String& process(stringone* strngn);

protected:
    void stage1_showpage();
    void stage1_process(stringone* strngn);
};


// Classe per la modifica dei dati relativi a un corrisp./affid./dipend. (op=7)
class ModCA: public Operation {
public:
    ModCA();
    String& process(stringone* strngn);
    void reset();

protected:
    SqlString Denominaz1;
    SqlString Denominaz2;
    SqlString Tipo;
    SqlString Via;
    SqlString Citta;
    SqlString Cap;
    SqlString Telefono;
    SqlString Fax;
    SqlString Titolo;    // solo per persona
    SqlString CodFisc;   // solo per persona
    SqlString Piva;      // solo per organizzazione
    SqlString Tramite;   // solo per organizzazione
    SqlString Ufficio;   // solo per dip. della biblioteca

    SqlInt codiceca;     // codice del corrisp./affid./dipend.
    
    void stage1_showpage();
    void stage1_showframe1();
    void stage2_showpage();
    void stage3_showpage();
    void stage1_process(stringone* strngn);
    void stage2_process(stringone* strngn);
    void stage3_process(stringone* strngn);
};


// Classe per effettuare query "ad uso interno" (op=8)
class QueryInt: public Operation {
public:
    QueryInt();
    String& process(stringone* strngn);
    void reset();
	
protected:
    void type1(stringone* strngn);   // query per lettera dei soli corrispondenti
    void type2(stringone* strngn);   // query per lettera di corrisp., affidatari e dipendenti
};


// Classe per le query sui documenti (op=9)
class QueryDoc: public Operation {
public:
    QueryDoc();
    ~QueryDoc();
    void init(int id, SqlConnection* c);	
    String& process(stringone* strngn);
    void reset();
	
protected:
    SqlInt preanno;
    SqlInt postanno;
    SqlInt prenumero;
    SqlInt postnumero;
    SqlDate predata;
    SqlDate postdata;
    SqlString Riparto;
    SqlInt codiceca;     // codice del mittente o del destinatario
    
    // queste non fanno parte della query, ma servono a me
    SqlString Oggetto;
    String cat;          // categoria del documento (carico o scarico)

    // non contemplate dall'attuale superquery, ma io le metto lo stesso
    SqlString Tipo_documento;

    // questo serve per la ricerca nel campo oggetto
    Finder* finder;
    
    void stage1_showpage();
    void stage2_showpage();
    void stage2_showframe1();
    void stage1_process(stringone* strngn);
    void stage2_process(stringone* strngn);
};


// Classe per effettuare query "semplici", cioe` che non richiedono la
// visualizzazione di form (op=10)
class QuerySimple: public Operation {
public:
    QuerySimple();
    void init(int id, SqlConnection* c);	
    String& process(stringone* strngn);
    void reset();
	
protected:
    SqlInt anno;
    
    bool aut_lettura;       // conoscere le autorizzazioni serve per decidere
    bool aut_inserimento;   // se mostrare o meno alcuni pulsanti
    bool aut_modifica;
    bool aut_cancellazione;

    void StampaCarta(stringone* strngn);    // type=1
    void RicScarichi(stringone* strngn);    // type=2
    void RicCarico(stringone* strngn);      // type=3
    void InfoDoc(stringone* strngn);        // type=4
    void InfoCA(stringone* strngn);         // type=5
    void RicAffid1(stringone* strngn);      // type=6
    void RicAffidTutti();                   // type=7
};


// Classe per le query sui corrispondenti/affidatari/dipendenti (op=11)
class QueryCA: public Operation {
public:
    QueryCA();
    String& process(stringone* strngn);
    void reset();

protected:
    SqlString Denominaz1;
    SqlString Denominaz2;
    
    void stage1_showpage();
    void stage1_process(stringone* strngn);
};


// Classe per le query all'interno del registro operazioni (op=12)
class QueryOp: public Operation {
public:
    QueryOp();
    String& process(stringone* strngn);

protected:
};


// Classe per il backup dei dati (op=14)
class BackUp: public Operation {
public:
    ErrorSupport;
    BackUp();
    String& process(stringone* strngn);
    void init(int id, SqlConnection* c);	
    void virtual reset();
    
protected:
    bool aut_lettura;
    bool aut_inserimento;
    bool aut_modifica;
    bool aut_cancellazione;
    int part;
    int diskNumber;
    int error;
    FILE* hardFile;
    
    FILE* createSave();
    bool copySave(FILE* hardFile);
    void stage1_showpage();
    void stage2_showpage();
    void stage3_showpage();
    void stage4_showpage();
    void stage0_process(stringone* strngn);
    void stage1_process(stringone* strngn);

private:
    char baklogname[256];   // nome del file registro dei backup
    int maxbakinterval;     // max # di giorni tra un backup e l'altro
};

// Classe per il backup dei dati (op=14)
class Restore: public Operation {
public:
    ErrorSupport;
    Restore();
    String& process(stringone* strngn);
    void init(int id, SqlConnection* c);	
    void virtual reset();
    
protected:
    int part;
    int diskNumber;
    FILE* hardFile;
    
    FILE* startRestore();
    bool copyLoad(FILE* hardFile);
    void endRestore();
    void stage1_showpage();
    void stage2_showpage();
    void stage3_showpage();
    void stage4_showpage();
    void stage0_process(stringone* strngn);
    void stage1_process(stringone* strngn);
    void stage4_process(stringone* strngn);
};


// Classe per la "cancellazione" di un c/a/d dalla base dati (op=15)
class CancCA: public Operation {
public:
    CancCA();
    String& process(stringone* strngn);

protected:
    void stage1_showpage();
    void stage1_showframe1();
    void stage1_process(stringone* strngn);
};


#endif
