/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: bridge.cc            ULTIMA MODIFICA: 11/08/1999        */
/*                                                                  */
/*  Codice per il programma bridge.                                 */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <iostream.h>
#include "bridge.h"
#include "html_utils.h"
#include "stringone.h"
#include "strings.h"

#define DEFAULT_PORT 1975		// anno di nascita degli sviluppatori


int Bridge::run() {
/*    int pt;
    try {
        channel.open("localhost", DEFAULT_PORT);
        channel << "NEW_USER";
        channel >> pt;
        channel.close();
        cout << "BRIDGE: nuovo utente, codice " << pt << "<BR>\n";
	}
	catch (Channel::Error e) {
            cout << "<BODY>\n";
	    cout << "BRIDGE - nella comunicazione con l'angelo si  verificata la seguente eccezione:\n";
	    cout << "<BR>\n<PRE>\n";
            cout << e << endl;
	    cout << "</PRE>\n</BODY>\n";
	    return(9);
	}

return 0;
*/
    // alloca le variabili
    char *buff;
    int l;

    // legge l'input proveniente dal web server
    l=leggi_input(buff);
    // se l non e` 0, qualcosa e` andato storto
    if (l!=0) {
        testa("M.O.N.K. - errore nel bridge");
        switch(l) {
        case 1:
            errore("Errore: la variabile d'ambiente CONTENT_LENGTH non esiste.");
            return(1);
        break;
        case 2:
            errore("Errore: CONTENT_LENGTH non contiene dati validi.");
            return(2);
        break;
        case 3:
            errore("Errore: allocazione del buffer fallita.");
            return(3);
        break;
        case 4:
            errore("Errore: la variabile d'ambiente QUERY_STRING non esiste.");
            return(4);
        break;
        case 5:
            errore("Errore: protocollo di comunicazione non riconosciuto.");
            return(5);
        break;
        default:
            errore("Errore: errore di tipo sconosciuto.");
            return(6);
        break;
        }
    }
    
    // inserisce l'input nella classe stringone
    stringone big_s;
    l=big_s.newstring(buff);
    if(l!=0) {
        testa("M.O.N.K. - errore nel bridge");
        errore("Errore nel passaggio dati alla classe stringone.");
        return(7);
    }
  
    // determina il codice dell'utente leggendo l'apposito token
    int userid;     // codice dell'utente
    int port;       // porta di comunicazione con l'angelo
    char* buff2;
    buff2=big_s.findtoken("userid");
    if(buff2==NULL) {
        testa("M.O.N.K. - errore nel passaggio parametri al bridge");
        errore("Il token obbligatorio 'userid' non esiste.");
        return(8);
    }
    userid=atoi(buff2);

    // se si arriva qui, si puo` stampare una intestazione tranquillizzante
    testa("M.O.N.K. - gestione del protocollo della corrispondenza");

    // se userid=0, allora si tratta di un nuovo utente
    // e bisogna creare un nuovo "angelo custode"
    if(userid==0) try {
        channel.open("localhost", DEFAULT_PORT);
        channel << "NEW_USER";
        channel >> port;
        channel.close();
//        cout << "BRIDGE: nuovo utente, codice " << port << "<BR>\n";
	} 
	catch (Channel::Error e) {
            cout << "<BODY>\n";
	    cout << "BRIDGE - nella comunicazione con l'angelo si  verificata la seguente eccezione:\n";
	    cout << "<BR>\n<PRE>\n";
            cout << e << endl;
	    cout << "</PRE>\n</BODY>\n";
	    coda();
	    return(9);
	}
    else port=userid;

    // a questo punto, dovrebbe esistere un angelo a cui passare
    // la stringa ricevuta dal web server
    String mess;

    try {
        channel.open("localhost", port);
        channel << buff;

        channel >> mess;
        channel.close();
    }
    catch (Channel::Error e) {
        cout << "<BODY>\n";
	cout << "BRIDGE - nella comunicazione con l'angelo si  verificata la seguente eccezione:\n";
	cout << "<BR>\n<PRE>\n";
        cout << e << endl;
	cout << "</PRE>\n</BODY>\n";
	coda();
        return(10);
    }

    // la risposta dell'angelo viene stampata brutalmente...
    cout << mess;
    
    //...dopodiche' il bridge termina
    coda();
    return(0);
}
