#ifndef _COMMUNICATION_H_
#define _COMMUNICATION_H_

/*
 *	La classe Channel crea il collegamento tra il bridge e angel. Si tratta quindi 
 *	di un componente comune ai due programmi. L'implementazione utilizza TCP/IP
 *	
 *	- la comunicazione  quindi affidabile
 *	- bridge e angel non devono risiedere sullo stesso host
 *	- la comunicazione  di tipo client-server
 *  
 *  _________________________________________________________________________________
 *  
 *  Interfaccia
 *       
 *  + port create(): crea un nuovo canale in modalit server
 *  			restituisce la porta su cui la connessione  attiva 
 *  + listen(timeout): aspetta al pi timeout secondi che un client si connetta
 *  			se il timeout scade viene generata una Channel::TimeOut exception
 *  			se non viene indicato un timeout, il timeout  infinito
 *  + open(hostName, port): apre un canale gi presente all'indirizzo
 *  			hostName:port in modalit client
 *  + close(): chiude una comunicazione (di solito non serve, si arrangia il distruttore)
 *  			
 *  _________________________________________________________________________________
 *  
 *  Utilizzo
 *  
 *  Bisogna prima creare un server con la funzione create. La porta restituita va 
 *  passata al client (in qualche modo). Il server si pone in modalit di ascolto con
 *  la funzione listen; quando il client apre la connessione sulla porta opportuna
 *  il server esce dalla modalit di ascolta e si possono utilizzare i normali
 *  operatori << e >> per spedire e ricevere stringhe.
 *  Una volta conclusa la connessione il client termina e il server si rimette 
 *  in ascolta   
 *  
 *  Ricapitolando
 *  
 *  server->    int port = channel.create()
 *  server->	channel.listen(TIMEOUT)
 *  
 *  client->	channel.open("localhost",port)
 *  client->	channel << "ciao mondo";
 *  
 *  server->	channel >> messaggio;
 *  server->    channel.listen(TIMEOUT)
 *  .
 *  .
 *  .
 *  
 */

 
#define __STRICT_ANSI__

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <strings.h>
//#include <unistd.h>

#include "string.h"

// NOTARE: per far andare il tutto sotto Windows bastano 4 righe
// POTENZA DI GNU!!!
#ifndef __linux__
#define socklen_t int
#define size_t int
#endif

#undef __STRICT_ANSI__

#include "exception.h"
#include "strings.h"


#define AUTO 0

class Channel {
public:
	class Timeout: public Exception {
	public:
		Timeout() {}
	};
	
	ErrorSupport;

	Channel();
	~Channel();
	
	int create(int port = AUTO);					//crea una nuova comunicazione
	void open(const String& hostName, int port);	//apre una comunicazione preesistente
	void close();									//chiude la comunicazione  

	void listen(int timeout=-1);					//aspetta una connessione

    static int freePort(int style);

protected:
	bool active;						// la comunicazione  attiva
  	int ownSocket;						// socket iniziale
  	int ioSocket;						// socket per comunicare
  	unsigned short int ownPort;			// porta utilizzata						
  	
  	struct sockaddr_in hostAddress;
  	unsigned int lengthOfHostAddress;
  	bool connectionAvailable;
  
  	void openSocket(int style, int port, size_t _bufferSize);	// apre il socket
  	void closeSocket();											// chiude il socket
 	sockaddr_in getHostInfo(const String& hostName, int port);// recupera informazioni sull'host

	void readData(void* data, size_t size);
	void writeData(const void* data, size_t size);

	friend Channel & operator << (Channel & channel, 
			const String & message);
	friend Channel & operator >> (Channel & channel, 
			String & message);
	friend Channel & operator << (Channel & channel, 
			int message);
	friend Channel & operator >> (Channel & channel, 
			int & message);

};

Channel & operator << (Channel & channel, 
	const String & message);
	
Channel & operator >> (Channel & channel, 
	String & message);

Channel & operator << (Channel & channel, 
	int);
	
Channel & operator >> (Channel & channel, 
	int &);

#endif
