
#include "exception.h"
#include "strings.h"

String *Exception::theFileName = NULL;
int Exception::theLineNumber = 0;
 
Exception::Exception() :  theDescription( NULL )
{
}

Exception::Exception(const String& aDescription, int aLevel) 
  : theLevel(aLevel), theDescription( new String( aDescription ) )
{
}

Exception::Exception(const Exception& exception) 
	: theLevel(exception.theLevel), theDescription(exception.theDescription) {
}

inline void Exception::resetFileName()
{
  if ( theFileName != NULL ) {
    delete theFileName;
    theFileName = NULL;
  }   
}

Exception::~Exception() {
  if ( theDescription != NULL ) {
    delete theDescription;
    theDescription = NULL;
  }
}

void Exception::setDescription(const String& aDescription )
{
  if ( theDescription != NULL ) {
    delete theDescription;
  }   
  theDescription = new String( aDescription );  
}

void Exception::setFileName(const String& fileName )
{
  resetFileName();
  theFileName = new String( fileName );  
}

void Exception::setLineNumber( int lineNumber )
{
  theLineNumber = lineNumber;  
}

const String Exception::description() const
{
  if ( theDescription != NULL ) {
    return String( *theDescription );
  }
  else {
    return String( "No description" );
  }
}

const String Exception::toString() const
{
  String output = String( "( Exception " );
  output = output + "'" + description() + "'";

  if ( theFileName != NULL && theLineNumber != 0 ) {
    output = output + ", thrown at " + *theFileName + ":" + 
      String( theLineNumber );
  }
  output = output + " )";    
  return output;
}

void Exception::printOn (ostream& anOutputStream ) const
{
  anOutputStream << toString().cString();
}


