#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_


#include <stream.h>

class String;

const int elWarning 	= 0;
const int elHalt		= 1;

class Exception {
public:
    Exception();
    Exception( const String& aDescription, int aLevel = elHalt);
    Exception( const Exception& exception);
    virtual ~Exception();

    static void setFileName( const String& fileName );
    void setDescription( const String& description );
    static void setLineNumber( int lineNumber );
    const String toString() const;
    const String description() const;
    void printOn (ostream& = cout) const;
private:
  	int theLevel;
  	String *theDescription;
  	static String *theFileName;
  	static int theLineNumber;
  
  	static void resetFileName();
};

#define throwException(anException) \
{ \
  Exception::setFileName( __FILE__ ); \
  Exception::setLineNumber( __LINE__ ); \
  throw anException; \
}

#define ErrorSupport class Error: public Exception {	\
  	public:							\
    	Error(const String& aDescription ): Exception( aDescription ) {}\
		Error(const Error& e): Exception(e.description()) {}\
  	}


inline ostream& operator<< (ostream& aStream, const Exception& object){
  object.printOn( aStream );
  return aStream;
}


#endif


