/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: html_utils.h             ULTIMA MODIFICA: 07/07/1999    */
/*                                                                  */
/*  Routine utili per il "colloquio" con il web server              */
/*                                                                  */
/*------------------------------------------------------------------*/

#ifndef _HTML_UTILS
#define _HTML_UTILS

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include "strings.h"


// Invia a stdout l'intestazione HTML.
void testa(char* titolopagina);

// Invia a stdout la "coda" HTML.
void coda();

// Stampa la stringa corrisp. all'inizio della sezione "BODY"
String beginbody();

// Stampa la stringa corrisp. alla fine della sezione "BODY"
String endbody();

// formatta un messaggio in Helvetica bold +2 (ideale per un titolo!)
String big_title(String testo_mess);

// formatta un messaggio in Helvetica bold (ideale per un titolosecondario)
String small_title(String testo_mess);

// Stampa un messaggio d'errore e chiude il file HTML
void errore(char* messaggio);

// Stampa il messaggio di un'eccezione (in puro testo) e chiude il file HTML
void eccezione(char* chi, char* messaggio);

// Pone in buff le informazioni inviate dal web server;
// la routine si occupa anche di allocare il buffer.
// Restituisce:
// 0 se e' tutto a posto;
// 1 se non riesce a leggere la var. d'ambiente CONTENT_LENGTH (metodo POST);
// 2 se la lunghezza dell'input e' nulla (metodo POST);
// 3 se non riesce ad allocare la memoria per il buffer (metodo POST);
// 4 se non riesce a leggere la var. d'ambiente QUERY_STRING (metodo GET);
// 5 se non riesce neppure a determinare il metodo di passaggio parametri.
int leggi_input(char* &buff);

#endif
