/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: stringone.cc         ULTIMA MODIFICA: 04/07/1999        */
/*                                                                  */
/*  Classe per la manipolazione e la decodifica degli "stringoni"   */
/*  che un web server passa ad un programma cgi-bin.                */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>
#include "stringone.h"


// Membri privati della classe "stringone"

int stringone::decodifica(char* buf_in, char* buf_out) {
    const int l=strlen(buf_in);
    if(l==0) {       // se la stringa ha lungh. nulla, esce subito
        *buf_out='\0';
        return 0;
    }
    int i=0, j=0;
    char minibuf[3];         // mini-buffer per i codici esadecimali
    minibuf[2]='\0';
    while(i<l) {
        switch(buf_in[i]) {
           case '+':
                buf_out[j]=' ';
                i++;
                j++;
            break;
           case '%':
                minibuf[0]=buf_in[i+1];
                minibuf[1]=buf_in[i+2];
                     buf_out[j]=(char)strtol(minibuf, NULL, 16);
                i=i+3;
                j++;
            break;
           default:
                buf_out[j]=buf_in[i];
                i++;
                j++;
            break;
        } // fine dello switch
    } // fine del ciclo while
    buf_out[j]='\0';
    return j;
}


// Membri pubblici della classe "stringone"

stringone::stringone() {
    // bisogna azzerare tutte le variabili e i puntatori
    buf_start=NULL;
    buf_pos=NULL;
    buf_end=NULL;
    lstr=0;
    numtok=0;
    
    lasttoken.name=NULL;
    lasttoken.namelen=0;
    lasttoken.value=NULL;
    lasttoken.valuelen=0;
}

stringone::~stringone() {
    reset();
}

void stringone::reset() {
    // bisogna liberare la memoria dei buffer e di lasttoken
    if(buf_start!=NULL) delete buf_start;
    buf_start=NULL;
    buf_pos=NULL;
    buf_end=NULL;
    lstr=0;
    numtok=0;
    
    if(lasttoken.name!=NULL) delete lasttoken.name;
    lasttoken.name=NULL;
    lasttoken.namelen=0;
    if(lasttoken.value!=NULL) delete lasttoken.value;
    lasttoken.value=NULL;
    lasttoken.valuelen=0;
}

void stringone::rewind() {
    buf_pos=buf_start;
}

int stringone::newstring(char* stringa) {
    int l=strlen(stringa);
    if(l==0) return 1;       // non accettiamo stringhe di lunghezza 0
    
    reset();                     // resetta la classe
    buf_start=new char[l+8];     // copia lo stringone nel buffer locale
    strcpy(buf_start, stringa);
    buf_pos=buf_start;
    lstr=l;
    buf_end=buf_start+lstr-1;
    
    numtok=0;                    // calcola il numero di token
    for(l=0; l<lstr; l++) if(buf_start[l]=='&') numtok++;
    numtok++;                    // l'ultimo token non e' seguito da "&"

    lasttoken.name=new char[lstr+8];    // meglio largheggiare con le
    lasttoken.value=new char[lstr+8];   // allocazioni di memoria...
    
    return 0;   // se il val. di ritorno e' 0, allora e' tutto OK
}

token* stringone::nexttoken() {
    if(buf_pos>buf_end) return NULL;    // niente piu' token!
    char* lbuf=new char[lstr+8];

    int i=0;                 // estrae un nuovo token (codificato)
    while((*buf_pos!='&')&&(buf_pos<=buf_end)) {
        lbuf[i]=*buf_pos;
	i++;
	buf_pos++;    
    }
    lbuf[i]='\0';            // termina la stringa che contiene il token
    buf_pos++;               // puntatore al token successivo
    
    int j=0;                 // decodifica il token
    while((lbuf[j]!='=')&&(j<i)) j++;
    lbuf[j]='\0';
    lasttoken.namelen=decodifica(lbuf, lasttoken.name);
    lasttoken.valuelen=decodifica(&lbuf[j+1], lasttoken.value);
    
    delete lbuf;
    return &lasttoken;
}

char* stringone::findtoken(char* nometoken) {
    char* buf_bak=buf_pos;   // backup della posiz. nello stringone
    
    // vediamo se riusciamo a trovare il token partendo dalla posiz. corrente
    while(nexttoken()!=NULL)
        if(strcmp(lasttoken.name, nometoken)==0) return lasttoken.value;

    // non e` stato trovato: allora esaminiamo lo stringone dall'inizio
    rewind();
    while(nexttoken()!=NULL)
        if(strcmp(lasttoken.name, nometoken)==0) return lasttoken.value;
    
    // ancora niente: allora il token non esiste, quindi bisogna ripristinare 
    // la posizione all'interno dello stringone e restituire NULL
    buf_pos=buf_bak;
    return NULL;
}
