/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: stringone.h          ULTIMA MODIFICA: 04/07/1999        */
/*                                                                  */
/*  Dichiarazioni per la classe stringone, che serve per la         */
/*  manipolazione e la decodifica degli "stringoni" che un web      */
/*  server passa ad un programma cgi-bin.                           */
/*                                                                  */
/*------------------------------------------------------------------*/

#ifndef _STRINGONE_CLASS
#define _STRINGONE_CLASS

struct token {
    char* name;      // nome del token
    int namelen;     // lungh. della stringa del token
    char* value;     // valore del token
    int valuelen;    // lungh. della stringa del valore
};


class stringone {

  private:

    char* buf_start;      // puntatore al primo carattere dello "stringone"
    char* buf_pos;        // posiz. corrente all'interno dello stringone
    char* buf_end;        // puntatore all'ultimo carattere dello stringone
    token lasttoken;      // buffer che contiene l'ultimo token esaminato

    int decodifica(char* buf_in, char* buf_out);

  public:

    int lstr;     // lungh dello stringone codificato (escluso il '\0' finale)
    int numtok;   // numero di token nello stringone

    // costruttore della classe
    stringone();

    // distruttore della classe
    ~stringone();

    // reinizializza completamente la classe
    void reset();

    // riporta il "cursore" all'inizio dello stringone
    void rewind();

    // inserisce nella classe un nuovo stringone da esaminare
    // restituisce 0 se e' andato tutto bene
    // restituisce 1 se il nuovo stringone ha lunghezza nulla
    int newstring(char* stringa);

    // decodifica il successivo token, avanzando il "cursore"
    // restituisce NULL se non ci sono piu' token
    token* nexttoken();
    
    // restituisce il valore del token "nometoken"
    // se il token non esiste, restituisce NULL
    // NOTA: questa funzione altera la posizione del cursore!
    
    char* findtoken(char* nometoken);

}; // fine della definizione della classe stringone

#endif
