#ifndef _STRING_CC_
#define _STRING_CC_


#include <stdio.h>
#include <errno.h>
#include <stdlib.h>

#include "strings.h"


String::String( const char *newValue )
{
  len = strlen( newValue ); 
  value = new char[len + 1];
  strcpy( value, newValue );
}

String::String( const int newValue ) 
{
  char tmpValue[20];

  sprintf( tmpValue, "%i", newValue );
  len = strlen( tmpValue );
  value = new char[len + 1];	
  strcpy( value, tmpValue );  
}


String::String( const long newValue ) 
{
  char tmpValue[20];

  sprintf( tmpValue, "%ld", newValue );
  len = strlen( tmpValue );
  value = new char[len + 1];
  strcpy( value, tmpValue );  
}

String::String( const double newValue )
{
  char tmpValue[25];

  sprintf( tmpValue, "%g", newValue );
  len = strlen( tmpValue );
  value = new char[len + 1];
  strcpy( value, tmpValue );  

}

String::String(const bool newValue) {
	if (newValue == true)
		String("true");
	else
		String("false");
}

String::String( const String& s )
{
  len = s.len;
  value = new char[ len+1 ];
  strcpy( value, s.value );  

}

String::String( int newLen, char a )
{
  len = newLen;
  value = new char [len+1];
  a = a;
}

const String& String::operator= ( const String& s ) {

  if ( this == &s ) {
    return *this;
  }
  
  if ( len < s.len ) {
    delete [] value;
    value = new char [s.len + 1];
  }

  strncpy( value, s.value, s.len + 1 );
  len = s.len;
  
  return *this; 
}


String operator+ ( const String& s1, const String& s2 )
{
  String sum( s1.len + s2.len, 'a' );  
  strcpy( sum.value, s1.value );
  strcat( sum.value, s2.value );
  return sum;
  
}

String String::leftString( int charCount ) const
{
  if ( charCount < 0 ) {
    charCount = 0;
  }
  else if ( charCount > len ) {
    charCount = len;
  }
  String result(charCount, 'd');
  strncpy(result.value, value, charCount);
  result.value[charCount] = '\0';
  return result;
}
  
String String::rightString( int charCount ) const
{
  if ( charCount < 0 ) {
    charCount = 0;
  }
  else if ( charCount > len ) {
    charCount = len;
  }
  return subString( len-charCount, charCount );
}

String & String::operator += (const String & other) {
	*this = *this + other;
	return *this;
}

String String::subString( int leftIndex, int charCount ) const
{
  if ( leftIndex < 0 ) {
    leftIndex = 0;
  }
  else if ( leftIndex > len ) {
    leftIndex = len;
  }
  
  if ( charCount == 0 ) {
    charCount = len - leftIndex;
  }
  else if ( charCount < 0 ) {
    charCount = 0;
  } 
  else if ( leftIndex+charCount > len ) {
    charCount = len-leftIndex;
  }

  String result(charCount, 'd');
  strncpy(result.value, value+leftIndex, charCount);
  result.value[charCount] = '\0';
  return result;
}

int String::asInt() const 
{
  int result = 0;
  if ( len > 0 ) {
    result = atoi( value );
  }
  return result;
}  
  
double String::asDouble() const 
{
  double result = 0;
  if ( len > 0 ) {
    result = atof( value );
  }
  return result;
}  
  
String String::toString() const 
{
  return *this;
}



String::~String()
{
	if (value != NULL)
		delete [] value;
  	value = NULL;
}



#endif



