#ifndef _STRINGS_H_
#define _STRINGS_H_

#include <string.h>
#include <iostream.h>
#include "exception.h"


class String 
{
public:
    class StringException: public Exception {
    public:
      StringException(const String& aDescription )
        : Exception( aDescription ) {}
    };

    class ConversionException: public StringException {
    public:
      ConversionException(const String& aDescription )
        : StringException( aDescription ) {}
    };
    
    String (const char* newValue="");
    String (const int newValue);
    String (const long newValue);
    String (const double newValue);
    String (const String& s);
    String (const bool newValue);
    virtual ~String ();

    friend bool operator== (const String&, const String&);
    friend bool operator!= (const String&, const String&);
    friend bool operator < (const String&, const String&);
    friend bool operator > (const String&, const String&);
    bool beginsWith( const String& String ) const;
    int length() const;

    friend String operator+ (const String&, const String&);
    const String& operator= (const String& s);
    String leftString( int charCount ) const;
    String rightString( int charCount ) const;
    String subString( int leftIndex, int charCount = 0 ) const;    
	String & operator += (const String & other);
    
    char *cString() const;
    int asInt() const;
    double asDouble() const;   
    virtual String toString() const;

private:
  char *value;
  
  int len;
  
  String(int length, char dummyParameter);
};


inline char *String::cString() const
{
  return value;
}

inline int String::length() const 
{
  return len;
}

inline bool operator== (const String& s1, const String& s2)
{ 
  return ( ( s1.value == s2.value ) || strcmp( s1.value, s2.value ) == 0 );
}

inline bool operator!= (const String& s1, const String& s2)
{
  return !(s1==s2);
}

inline bool operator < (const String& s1, const String& s2)
{ 
  return (strcmp( s1.value, s2.value ) < 0);
}

inline bool operator > (const String& s1, const String& s2)
{
  return (strcmp( s1.value, s2.value) > 0);
}

inline bool String::beginsWith( const String& String ) const 
{
//  return (strncasecmp(cString(), String.cString(), String.length()) == 0);
return true;
}

inline ostream& operator << (ostream & o, const String & s) {
	o << s.cString();
	return o;
}

#endif
