#include <iostream.h>
#include "sqlconnection.h"
#include "mysql.h"
#include <stdlib.h>

#define sqlException(string) \
{\
    unlock(); \
    throwException(string); \
}

#define exiterr(exitcode) \
{ \
  sqlException(GenericError(mysql));\
}


SqlConnection::GenericError::GenericError(MYSQL &mysql): 
                Exception(mysql_error(&mysql)) {
                }


SqlConnection::GenericError::GenericError(const GenericError & e): 
                Exception(e.description()) {}

SqlConnection::GenericError::GenericError(char *errore): 
                Exception(errore) {}

SqlConnection::SqlConnection() {
	connected = false;
}

SqlConnection::~SqlConnection() {
    disconnect();
}

void SqlConnection::connect(const String & host, const String & user,
    const String & passwd) {
       if (!(mysql_connect(&mysql, host.cString(), user.cString(),
           passwd.cString()))) exiterr(1);
		nameUser=user;
		nameDB = "cherubino";
        if (mysql_select_db(&mysql,nameDB.cString()))
                exiterr(2);
        cout << "connessione avvenuta con dB " << nameDB << endl;
		initautorizzation(user);
	connected = true;
}


void SqlConnection::disconnect() {
    // qui bisogna scrivere qualcosa: va bene cosi`?
    mysql_close(&mysql);
    cout << "disconnessione dal dB avvenuta\n";
}

void SqlConnection::initautorizzation(const String & user){

	MYSQL_ROW row; 
	char* autorizzazione;

	nameUser=user;
    String query = "SELECT Autorizzazione FROM DIPENDENTE_INFO_AGG \
    WHERE Codice_dip=" + nameUser;

    mySqlQuery(query);

    myStoreResult();

	row = mysql_fetch_row(res);
	autorizzazione=row[0];
//	cout << autorizzazione << endl;


	if (!strncmp("1",autorizzazione,1)) lettura=true;
	else lettura=false;

	autorizzazione++;

	if (!strncmp("1",autorizzazione,1)) scrittura=true;
	else scrittura=false;

	autorizzazione++;

	if (!strncmp("1",autorizzazione,1)) modifica=true;
	else modifica=false;

	autorizzazione++; 

	if (!strncmp("1",autorizzazione,1)) cancellazione=true;
	else cancellazione=false;

	if (lettura) cout << "lettura ";
	if (scrittura) cout << "scrittura ";
	if (modifica) cout << "modifica ";
	if (cancellazione) cout << "cancellazione ";
	cout << endl;
}


void SqlConnection::insertRiparto(SqlString Codice, SqlString Significato) {

	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	String query = "insert into RIPARTO values(";
	query += Codice.sql() + ",";
	query += Significato.sql() + ")";

    mySqlQuery(query);
    
    effectrow=mysql_affected_rows(&mysql);
	if(effectrow<=0) sqlException(GenericError(erroreop));
}

int SqlConnection::insertCorrispondente_affidatario(
    SqlString Denominaz1, SqlString Denominaz2, SqlString Tipo, 
    SqlString Via, SqlString Citta, SqlString CAP, SqlString Telefono, 
    SqlString FAX, SqlString Obsoleto){

    lock();
    
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));
	

	int effectrow;
	char* erroreop="operazione non avvenuta";
	SqlInt Codice;
	int numrighe,progressive;
	char *progstring;
	char *erroreprogr="errore nel calcolo del progressivo";
	char *errorenome="esiste gia' una tupla con queste denominazioni";

	String query="SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE\
	Denominaz1=" + Denominaz1.sql() + "AND Denominaz2=" + Denominaz2.sql();

	mySqlQuery(query);

	myStoreResult();

	numrighe=mysql_num_rows(res);
	
	if (numrighe>0) sqlException(GenericError(errorenome));

	query="SELECT MAX(Codice) FROM  CORRISPONDENTE_AFFIDATARIO";

	mySqlQuery(query);

	myStoreResult();

	numrighe=mysql_num_rows(res);
	cout << "numero di righe individuate "<< numrighe << endl; 
	if (numrighe==1){
		row = mysql_fetch_row(res);
		progstring=row[0];
		cout << "max(Codice) = " << progstring << endl;
		if (progstring == NULL)
		return 1;
		progressive=atoi(progstring);
		progressive+=1;
		cout << "progressivo = " << progressive << endl; 

	mysql_free_result(res);
	}
	else sqlException(GenericError(erroreprogr));
	Codice=progressive;

	query = "insert into CORRISPONDENTE_AFFIDATARIO values(";
	query += Codice.sql() + ",";
	query += Denominaz1.sql() + ",";
	query += Denominaz2.sql() + ",";
	query += Tipo.sql() + ",";
	query += Via.sql() + ",";
	query += Citta.sql() + ",";
	query += CAP.sql() + ",";
	query += Telefono.sql() + ",";
	query += FAX.sql() + ",";
	query += Obsoleto.sql() + ")";

	mySqlQuery(query);

	effectrow=mysql_affected_rows(&mysql);
	if(effectrow<=0) sqlException(GenericError(erroreop));

    unlock();
    return progressive;
}

void SqlConnection::insertCorrispOrganizzazione(SqlInt Codice, SqlString Piva,
        SqlString Tramite){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" 
		+ Codice.sql();

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;

	mysql_free_result(res);

	if (foreignkey==true){ 

		query = "insert into CORRISP_ORGANIZZAZIONE values(";
		query += Codice.sql() + ",";
		query += Piva.sql() + ",";
		query += Tramite.sql() + ")";

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));
	}
	else sqlException(GenericError(errorefk));

	unlock();
}
        
void SqlConnection::insertCorrispPersona(SqlInt Codice, SqlString Titolo,SqlString Codfisc){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" 
		+ Codice.sql();

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;

	mysql_free_result(res);

	if (foreignkey==true){ 

		query = "insert into CORRISP_PERSONA values(";
		query += Codice.sql() + ",";
		query += Titolo.sql() + ",";
		query += Codfisc.sql() + ")";

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));
	}
	else sqlException(GenericError(errorefk));
    unlock();
}

void SqlConnection::insertDipendenteInfoAgg(SqlInt Codice, SqlString Ufficio,
        SqlString Autorizzazione){
    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" 
		+ Codice.sql();

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;

	mysql_free_result(res);

	if (foreignkey==true){ 

		query = "insert into DIPENDENTE_INFO_AGG values(";
		query += Codice.sql() + ",";
		query += Ufficio.sql() + ",";
		query += Autorizzazione.sql() + ")";

		mySqlQuery(query);
		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));
	}
	else sqlException(GenericError(errorefk));
    unlock();
}

SqlInt SqlConnection::insertCarico(SqlInt anno, SqlDate data, 
        SqlString oggetto,SqlString tipoDoc, SqlString riparto, SqlInt mittente, 
        SqlDate dataAtto, SqlString numeroAtto, SqlDate dataFax) {

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	SqlInt numero;
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	/* ricavo il numero del protocollo */

	SqlInt maxcarico=progressivoCarico(anno);
	SqlInt maxscarico=progressivoScarico(anno);

	if (maxcarico<maxscarico) {
		numero=maxscarico;
	}
	else numero=maxcarico;

	String query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" 
	+ mittente.sql();

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
	mysql_free_result(res);

	query = "SELECT * FROM RIPARTO WHERE Codice=" + riparto.sql();
	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;

	mysql_free_result(res);

	if (foreignkey==true){ 
		query = "insert into CARICO values(";
		query += anno.sql() + ",";
		query += numero.sql() + ",";
		query += data.sql() + ",";
		query += oggetto.sql() + ",";
		query += tipoDoc.sql() + ",";
		query += riparto.sql() + ",";
		query += mittente.sql() + ",";
		query += dataAtto.sql() + ",";
		query += numeroAtto.sql() + ",";
		query += dataFax.sql() + ")";

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop)); 
	}
	else sqlException(GenericError(errorefk));

    unlock();
    return numero;           
}



SqlInt SqlConnection::insertScarico(SqlInt anno, SqlDate data, SqlString oggetto,
                SqlString tipoDoc, SqlString classifica, SqlInt destinatario,SqlString annotazioni){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	SqlInt numero;
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";
        
        /* ricavo il numero del protocollo */
        
	SqlInt maxcarico=progressivoCarico(anno);
	SqlInt maxscarico=progressivoScarico(anno);
	if (maxcarico<maxscarico) {
		numero=maxscarico;
	}
	else numero=maxcarico;

	String query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" + destinatario.sql();
//	cout << query << endl;
	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
	mysql_free_result(res);

	query = "SELECT * FROM RIPARTO WHERE Codice=" + classifica.sql();
//	cout << query << endl;
	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
	mysql_free_result(res);
	if (foreignkey==true){ 
		query = "insert into SCARICO values(";
		query += anno.sql() + ",";
		query += numero.sql() + ",";
		query += data.sql() + ",";
		query += oggetto.sql() + ",";
		query += tipoDoc.sql() + ",";
		query += classifica.sql() + ","; 
		query += destinatario.sql() + ")";
//		cout << query << endl;

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));

		if (!annotazioni.isNull()){
			query = "insert into SCARICO_INFO_OPZ values(";
			query += anno.sql() + ",";
			query += numero.sql() + ",";
			query += annotazioni.sql() + ")";

			mySqlQuery(query);

			effectrow=mysql_affected_rows(&mysql);
			if(effectrow<=0) sqlException(GenericError(erroreop));
		}
	}
        else sqlException(GenericError(errorefk));

    unlock();
    return numero;
}       

void SqlConnection::insertCorrispondenza(SqlInt annoscarico, 
        SqlInt numeroscarico,SqlInt annocarico, SqlInt numerocarico){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM SCARICO WHERE Anno=" +annoscarico
		+ " AND Numero=" + numeroscarico;

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
	mysql_free_result(res);

	query = "SELECT * FROM CARICO WHERE Anno=" +annocarico
		+ " AND Numero=" + numerocarico;

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
	mysql_free_result(res);
	if (foreignkey==true){ 

		query = "insert into CORRISPONDENZA values(";
		query += annoscarico.sql() + ",";
		query += numeroscarico;
		query +=",";
		query += annocarico;
		query +=",";
		query += numerocarico;
		query +=")";

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));
	}
        else
        {
                sqlException(GenericError(errorefk)); 
        }
    unlock();
}


void SqlConnection::insertAffidamento (SqlInt annocarico, 
        SqlInt numerocarico,SqlInt codiceaffidatario, SqlDate datainizioaff){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
	bool foreignkey = true;
	SqlDate datafineaff=null;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM CARICO WHERE Anno=" +annocarico
		+ " AND Numero=" + numerocarico;

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;

	mysql_free_result(res);
	query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" +
	codiceaffidatario;

	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
		mysql_free_result(res);
	if (foreignkey==true){ 
		query = "insert into AFFIDAMENTO values(";
		query += annocarico.sql() + ",";
		query += numerocarico.sql() + ",";
		query += codiceaffidatario.sql() + ",";
		query += datainizioaff.sql() + ","; 
		query += datafineaff.sql() + ")";

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));

        }
        else
        {
                sqlException(GenericError(errorefk)); 
        }
    unlock();
}

void SqlConnection::insertFineAffidamento (SqlInt annocarico, SqlInt numerocarico,
                 SqlDate datafineaff){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
        SqlResult result2;
	SqlInt codiceaff;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM  AFFIDAMENTO WHERE Anno_carico=" +annocarico
		+ " AND Numero_carico=" + numerocarico + " AND ISNULL(Data_fine_aff)";

	mySqlQuery(query);
	myStoreResult(); 
	result2.store(res);      

	numrighe=result2.rowNum();
	if (numrighe!=1) foreignkey=false;
	if (foreignkey==true){
		codiceaff=result2.get(0,2);
		query = "update AFFIDAMENTO set Data_fine_aff="+datafineaff.sql()
                        +" WHERE Anno_carico="+annocarico+" AND Numero_carico="
			+numerocarico+" AND Codice_affidatario="+codiceaff;
		mySqlQuery(query);
		
		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));
	}
	else{
		sqlException(GenericError(errorefk)); 
		}

    unlock();
}

void SqlConnection::insertOperazione(SqlInt codiceoperatore,
	SqlDate dataoperazione,SqlInt oraoperazione,
	SqlString tipooperazione){

    lock();
	char* erroreauto="non autorizzato";
	if (!scrittura) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	int numrighe;
	bool foreignkey = true;
	char *errorefk="Mancata corrispondenza della chiave esterna";

	String query = "SELECT * FROM DIPENDENTE_INFO_AGG WHERE Codice_dip=" 
		+ codiceoperatore.sql();

	mySqlQuery(query);
	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) foreignkey=false;
	mysql_free_result(res);
	if (foreignkey==true){ 
		query = "insert into OPERAZIONE values(";
		query += codiceoperatore.sql() + ",";
		query += dataoperazione.sql() + ",";
		query += oraoperazione.sql() + ",";
		query += tipooperazione.sql() + ")";

		mySqlQuery(query);

		effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop));

        }
        else sqlException(GenericError(errorefk));

    unlock();
}

void SqlConnection::insertUtente(SqlInt codice,SqlString password,SqlString autorizzazioni){

    lock();
	char* erroreauto="non autorizzato";
	if ((!scrittura) && (!lettura) && (!modifica) && (!cancellazione)) 
	sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="errore nell'inserimento delle autorizzazioni nel database";
	char* erroreopuser="utente non inserito (grant table)";
	char* erroreopdb="inserimento legame utente database non avvenuto (grant table)";
	char* erroredip="il codice non e' relativo un dipendente della biblioteca";
	int numrighe;

	String query = "SELECT * FROM DIPENDENTE_INFO_AGG WHERE \
		Codice_dip=" + codice.sql();
	mySqlQuery(query);

	myStoreResult(); 

	numrighe=mysql_num_rows(res);
	if (numrighe!=1) sqlException(GenericError(erroredip));	

	mysql_select_db(&mysql, "mysql");
	
	query = "INSERT INTO user VALUES ('localhost'," + 
		codice.sql() + " ,password(" + password.sql() + 
		"),'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','N','N','N')";

	mySqlQuery(query);

	effectrow=mysql_affected_rows(&mysql);
	if(effectrow<=0) {
		mysql_select_db(&mysql, "cherubino");
		mySqlQuery(query);
		sqlException(GenericError(erroreopuser));
	}
	
	query = "INSERT INTO db VALUES ('localhost','" + nameDB + 
	"'," + codice.sql() 
	+",'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y')";

	mySqlQuery(query);

	effectrow=mysql_affected_rows(&mysql);
	if(effectrow<=0) {
		mysql_select_db(&mysql, "cherubino");
		mySqlQuery(query);
		sqlException(GenericError(erroreopdb));
	}
mysql_select_db(&mysql, "cherubino");

	query = "update DIPENDENTE_INFO_AGG set Autorizzazione=" +autorizzazioni.sql();

	mySqlQuery(query);

	effectrow=mysql_affected_rows(&mysql);
	if(effectrow<=0) sqlException(GenericError(erroreop));

	unlock();
}


SqlResult* SqlConnection::queryCaricoChiave(SqlInt preanno,SqlInt postanno, SqlInt prenumero, 
        SqlInt postnumero){

	char* erroreauto="non autorizzato";
    if (lettura) sqlException(GenericError(erroreauto));    

        String query = "SELECT * FROM CARICO WHERE anno >= " + preanno + " AND anno <= " 
                + postanno + " AND numero >= " + prenumero + " AND numero <=" 
                + postnumero;
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

    return &result;
}

SqlResult* SqlConnection::queryScaricoChiave(SqlInt preanno,SqlInt postanno, SqlInt prenumero, 
        SqlInt postnumero){
        
	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT * FROM SCARICO WHERE anno >= " + preanno + " AND anno <= " 
                + postanno + " AND numero >= " + prenumero + " AND numero <=" 
                + postnumero;
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

    return &result;
}

SqlResult* SqlConnection::queryPerLettera(SqlString lettera){

	char* erroreauto="non autorizzato";
	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT Codice,Denominaz1,Denominaz2,Via,Citta FROM \
        CORRISPONDENTE_AFFIDATARIO WHERE Denominaz1 LIKE \"" + 
        lettera + "%\" AND Obsoleto != 'SCADUTO' \
        ORDER BY Denominaz1, Denominaz2 ASC";
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;

		
//        cout << result << endl;         
		
    return &result;
}

SqlResult* SqlConnection::queryPerLetteraTipo(SqlString lettera){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT Codice,Denominaz1,Denominaz2,Via,Citta,Tipo FROM \
        CORRISPONDENTE_AFFIDATARIO WHERE Denominaz1 LIKE \"" + 
		lettera + "%\" AND Obsoleto != 'SCADUTO'	\
		ORDER BY Denominaz1, Denominaz2 ASC";
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;

		
        cout << result << endl;         
		
    return &result;
}


int SqlConnection::progressivoCarico(SqlInt anno){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        int numrighe,progressive;
        char *progstring;
        char *erroreprogr="errore nel calcolo del progressivo";
        
        String query="SELECT MAX(Numero) FROM CARICO WHERE Anno="
        + anno;
        
        mySqlQuery(query);
        myStoreResult();
        numrighe=mysql_num_rows(res);

                cout << "numero di righe individuate "<< numrighe << endl; 
        if (numrighe==1){
                row = mysql_fetch_row(res);
                progstring=row[0];
                cout << "max(numero) = " << progstring << endl;
                        if (progstring == NULL)
                return 1;

                        progressive=atoi(progstring);
                progressive+=1;
                cout << "progressivo = " << progressive << endl; 
                mysql_free_result(res);
        }
                else sqlException(GenericError(erroreprogr));

        return progressive;
}

int SqlConnection::progressivoScarico(SqlInt anno){

	char* erroreauto="non autorizzato";
	if (!lettura) sqlException(GenericError(erroreauto));

        int numrighe,progressive;
        char *progstring;
        
        String query="SELECT MAX(Numero) FROM SCARICO WHERE Anno="
        + anno;
        
        mySqlQuery(query);
        myStoreResult();
        numrighe=mysql_num_rows(res);

                cout << "numero di righe individuate "<< numrighe << endl; 
        if (numrighe==1){
                row = mysql_fetch_row(res);
                progstring=row[0];
            cout << "max(numero) = " << progstring << endl;
                        if (progstring == NULL)
                return 1;

                progressive=atoi(progstring);
                progressive+=1;
                cout << "progressivo = " << progressive << endl; 
                mysql_free_result(res);
        }
                else cout << "errore nel calcolo del progressivo" << endl;

        return progressive;
}

SqlResult* SqlConnection::queryOggettoCarico(){

	char* erroreauto="non autorizzato";
	if (!lettura) sqlException(GenericError(erroreauto));

	String query = "SELECT Anno, Numero, Oggetto FROM CARICO";
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

    return &result;
}


SqlResult* SqlConnection::queryOggettoScarico(){

String query = "SELECT Anno, Numero, Oggetto FROM SCARICO";

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));                       

        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

        return &result;
}


SqlResult* SqlConnection::queryCorrispondenza(SqlInt anno,
        SqlInt numero){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT CORRISPONDENZA.Anno_scarico, \
        	CORRISPONDENZA.Numero_scarico, SCARICO.Oggetto\
            FROM CORRISPONDENZA,SCARICO WHERE CORRISPONDENZA.Anno_carico=" + anno
            +" AND CORRISPONDENZA.Numero_carico=" + numero + " AND SCARICO.Anno=\
            CORRISPONDENZA.Anno_scarico AND SCARICO.Numero=\
            CORRISPONDENZA.Numero_scarico \
            ORDER BY CORRISPONDENZA.Anno_scarico, CORRISPONDENZA.Numero_scarico ASC"; 
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;

 //         cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryRiparto(){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT * FROM RIPARTO ORDER BY Codice";
                        
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryAffidamentoFuori(){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	String query = "SELECT AFFIDAMENTO.Anno_carico, AFFIDAMENTO.Numero_carico, \
	CARICO.Oggetto,	CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
	CORRISPONDENTE_AFFIDATARIO.Denominaz2, \
	AFFIDAMENTO.Data_inizio_aff,CORRISPONDENTE_AFFIDATARIO.Codice\
	FROM CORRISPONDENTE_AFFIDATARIO,AFFIDAMENTO,CARICO \
	WHERE CARICO.Anno=AFFIDAMENTO.Anno_carico AND \
	CARICO.Numero=AFFIDAMENTO.Numero_carico AND \
	CORRISPONDENTE_AFFIDATARIO.Codice=AFFIDAMENTO.Codice_affidatario\
	AND ISNULL(AFFIDAMENTO.Data_fine_aff) \
	ORDER BY AFFIDAMENTO.Anno_carico, AFFIDAMENTO.Numero_carico ASC";
                  
        mySqlQuery(query);
                
        myStoreResult(); 
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryOutCartaCarico(SqlInt anno){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT CARICO.Numero,CARICO.Ladata,CARICO.Oggetto,\
                CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
                CORRISPONDENTE_AFFIDATARIO.Denominaz2,\
                CARICO.Data_atto, CARICO.Num_atto, CARICO.Riparto \
                FROM CARICO,CORRISPONDENTE_AFFIDATARIO WHERE \
                CARICO.Anno=" + anno.sql() +
                " AND CARICO.Mittente=CORRISPONDENTE_AFFIDATARIO.Codice\
                ORDER BY CARICO.Numero,CARICO.Ladata ASC";
        mySqlQuery(query);
                
        myStoreResult(); 
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryOutCartaScarico(SqlInt anno){

	char* erroreauto="non autorizzato";
	 if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT SCARICO.Numero,SCARICO.Ladata,SCARICO.Oggetto,\
        CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
        CORRISPONDENTE_AFFIDATARIO.Denominaz2, SCARICO.Classifica, \
        SCARICO_INFO_OPZ.Annotazioni FROM CORRISPONDENTE_AFFIDATARIO,\
        SCARICO LEFT JOIN SCARICO_INFO_OPZ ON \
        (SCARICO.Numero=SCARICO_INFO_OPZ.Numero AND SCARICO.Anno=SCARICO_INFO_OPZ.Anno) \
        WHERE SCARICO.Anno=" + anno.sql() +
	"AND SCARICO.Destinatario=CORRISPONDENTE_AFFIDATARIO.Codice \
        ORDER BY SCARICO.Numero,SCARICO.Ladata ASC";
        
        mySqlQuery(query);
                
        myStoreResult(); 
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryCarico(SqlInt preanno, 
        SqlInt postanno, SqlInt prenumero, SqlInt postnumero,
        SqlDate predata, SqlDate postdata, SqlString riparto, 
        SqlInt mittente, KeyArray & array) {

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT CARICO.Anno, CARICO.Numero,CARICO.Ladata,\
	CARICO.Oggetto, CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
        CORRISPONDENTE_AFFIDATARIO.Denominaz2, CARICO.Riparto \
        FROM CARICO LEFT JOIN CORRISPONDENTE_AFFIDATARIO ON \
        (CARICO.Mittente=CORRISPONDENTE_AFFIDATARIO.Codice)  WHERE Anno > 0 ";

        if (preanno.isNull() == false) 
           query += " AND Anno >= " + preanno;

        if (postanno.isNull() == false) 
           query += " AND Anno <= " + postanno;

        if (prenumero.isNull() == false) 
           query += " AND Numero >= " + prenumero;

        if (postnumero.isNull() == false) 
           query += " AND Numero <= " + postnumero;

        if (predata.isNull() == false) 
           query += " AND Ladata >= " + predata.sql();

        if (postdata.isNull() == false) 
           query += " AND Ladata <= " + postdata.sql();

        if (riparto.isNull() == false) 
           query += " AND Riparto = " + riparto.sql();

        if (mittente.isNull() == false) 
           query += " AND Mittente = " + mittente.sql();
        query += " AND ( Anno > 0 "; 
    if (array.count>0){
                query += " AND ( ";
        int i=0;
        for (i=0; i < (array.count-1); ++i) {
                query += " (Anno = " + array.items[i].anno + 
                " AND Numero = " + array.items[i].numero + ")"
                + " OR ";
                } 
                query += " (Anno = " + array.items[i].anno + 
        " AND Numero = " + array.items[i].numero + "))";
        }
        query += ")";

                
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

    return &result;

}

SqlResult* SqlConnection::queryScarico(SqlInt preanno, 
        SqlInt postanno, SqlInt prenumero, SqlInt postnumero,
        SqlDate predata, SqlDate postdata, SqlString riparto, 
        SqlInt mittente, KeyArray & array) {

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

        String query = "SELECT SCARICO.Anno, SCARICO.Numero, SCARICO.Ladata,\
	SCARICO.Oggetto, CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
        CORRISPONDENTE_AFFIDATARIO.Denominaz2, SCARICO.Classifica\
	FROM CORRISPONDENTE_AFFIDATARIO,\
	SCARICO LEFT JOIN SCARICO_INFO_OPZ ON \
	(SCARICO.Numero=SCARICO_INFO_OPZ.Numero AND SCARICO.Anno=SCARICO_INFO_OPZ.Anno)\
	WHERE SCARICO.Anno > 0 AND \
	SCARICO.Destinatario=CORRISPONDENTE_AFFIDATARIO.Codice";
        
        if (preanno.isNull() == false) 
           query += " AND SCARICO.Anno >= " + preanno;

        if (postanno.isNull() == false) 
           query += " AND SCARICO.Anno <= " + postanno;

        if (prenumero.isNull() == false) 
           query += " AND SCARICO.Numero >= " + prenumero;

        if (postnumero.isNull() == false) 
           query += " AND SCARICO.Numero <= " + postnumero;

        if (predata.isNull() == false) 
           query += " AND Ladata >= " + predata.sql();

        if (postdata.isNull() == false) 
           query += " AND Ladata <= " + postdata.sql();

        if (riparto.isNull() == false) 
           query += " AND Classifica = " + riparto.sql();

        if (mittente.isNull() == false) 
           query += " AND Destinatario = " + mittente.sql();
        query += " AND ( SCARICO.Anno > 0 "; 
    if (array.count>0){
                query += " AND ( ";
        int i=0;
        for (i=0; i < (array.count-1); ++i) {
                query += " (SCARICO.Anno = " + array.items[i].anno + 
                " AND SCARICO.Numero = " + array.items[i].numero + ")"
                + " OR ";
                } 
                query += " (SCARICO.Anno = " + array.items[i].anno + 
        " AND SCARICO.Numero = " + array.items[i].numero + "))";
        }
        query += ")";

                
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);

        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

    return &result;

}

SqlResult* SqlConnection::queryAutorizzazioni(SqlInt login){

char* erroreauto="non autorizzato";
 if (!lettura) sqlException(GenericError(erroreauto));

		/* da omettere login nel caso in cui le autorizzazioni si gestiscono da DB */
		/* MYSQL_ROW row; da aggiungere nel caso della modifica */
        String query = "SELECT Autorizzazione FROM DIPENDENTE_INFO_AGG \
        WHERE Codice_dip=" + login;
        /* ora ci si collega come root, se in seguito lo si fara' come
         * utente con una propria login e' sufficiente sostituire  a
         * login la variabile nameUser di tipo string e privata, non ci
         * dovrebbero essere problemi fra il campo codice_dip intero e 
         * la stringa nameUser */                
		/*
        mySqlQuery(query);
        myStoreResult();
		row = mysql_fetch_row(res);
        cout << row[0] << endl;        
		da aggiungere nel caso della modifica e togliere il sottostante
        inoltre la riga individuata fornisce le autorizzazioni, ricordo che
        il numero di tuple individuate dovrebbe essere 1 dato che codice_dip e'
        chiave primaria*/
        /* inizia a togliere*/
        mySqlQuery(query);
        myStoreResult();
		 
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//        cout << result << endl;         

        return &result;
		/* togliere fino a qui */
}

bool SqlConnection::autorizzato_lettura() { return lettura; }

bool SqlConnection::autorizzato_inserimento() { return scrittura; }

bool SqlConnection::autorizzato_modifica() { return modifica; }

bool SqlConnection::autorizzato_cancellazione() { return cancellazione; }

SqlResult* SqlConnection::queryPadreScarico(SqlInt anno,
	SqlInt numero){

	char* erroreauto="non autorizzato"; 
	if (!lettura) sqlException(GenericError(erroreauto));

	int numrighe;
	char *errorepadre="ad uno scarico sono associari piu' carichi";
	char *errorenessuno="nessun carico associato a questo scarico";

	String query = "SELECT CORRISPONDENZA.Anno_carico, \
	CORRISPONDENZA.Numero_carico, CARICO.Oggetto\
	FROM CORRISPONDENZA,CARICO WHERE CORRISPONDENZA.Anno_scarico=" + anno
	+" AND CORRISPONDENZA.Numero_scarico=" + numero + " AND CARICO.Anno=\
	CORRISPONDENZA.Anno_carico AND CARICO.Numero=\
	CORRISPONDENZA.Numero_carico \
	ORDER BY CORRISPONDENZA.Anno_carico, CORRISPONDENZA.Numero_carico ASC";    ;

	mySqlQuery(query);
	myStoreResult();
 	numrighe=mysql_num_rows(res);
	if (numrighe > 1) sqlException(GenericError(errorepadre));
	if (numrighe == 0) sqlException(GenericError(errorenessuno));

        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;

 //          cout << result << endl;         

        return &result;
}


SqlResult* SqlConnection::queryInfoCarico(SqlInt anno,SqlInt numero){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	String query = "SELECT CARICO.Numero,CARICO.Ladata,CARICO.Oggetto,\
	CARICO.Tipo_documento,CARICO.Riparto, \
	CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
	CORRISPONDENTE_AFFIDATARIO.Denominaz2,\
	CARICO.Data_atto, CARICO.Num_atto,CARICO.Data_fax \
	FROM CARICO,CORRISPONDENTE_AFFIDATARIO WHERE \
	CARICO.anno =  " + anno.sql() +" AND CARICO.numero = "
	+ numero.sql() + 
	" AND CARICO.Mittente=CORRISPONDENTE_AFFIDATARIO.Codice\
	ORDER BY CARICO.Numero,CARICO.Ladata ASC";
                 
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//       cout << result << endl;         

        return &result;
     
}

int SqlConnection::queryEsisteScaricoAssociato(SqlInt anno,SqlInt numero){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	int numrighe,valreturn;
	String query = "SELECT * FROM CORRISPONDENZA WHERE \
	CORRISPONDENZA.Anno_carico=" + anno + \
	" AND CORRISPONDENZA.Numero_carico=" + numero;
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
    if (numrighe>0) valreturn=1;
    else valreturn=0;
    mysql_free_result(res);
//	cout << valreturn << endl;
    return valreturn;
}

int SqlConnection::queryEsisteAffidamento(SqlInt anno,SqlInt numero){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	int numrighe,valreturn;
	String query = "SELECT * FROM AFFIDAMENTO WHERE \
	AFFIDAMENTO.Anno_carico=" + anno + \
	" AND AFFIDAMENTO.Numero_carico=" + numero;
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
    if (numrighe>0) valreturn=1;
    else valreturn=0;
    mysql_free_result(res);
// 	cout << valreturn << endl;
    return valreturn;
}

SqlResult* SqlConnection::queryInfoScarico(SqlInt anno,SqlInt numero){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

		String query = "SELECT SCARICO.Numero,SCARICO.Ladata,SCARICO.Oggetto,\
        SCARICO.Tipo_documento,SCARICO.Classifica,\
        CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
        CORRISPONDENTE_AFFIDATARIO.Denominaz2,  \
        SCARICO_INFO_OPZ.Annotazioni FROM CORRISPONDENTE_AFFIDATARIO,\
        SCARICO LEFT JOIN SCARICO_INFO_OPZ ON \
        (SCARICO.Numero=SCARICO_INFO_OPZ.Numero AND SCARICO.Anno=SCARICO_INFO_OPZ.Anno) \
        WHERE SCARICO.Anno=" + anno.sql() +" AND SCARICO.Numero=" 
        + numero.sql() + "AND SCARICO.Destinatario=CORRISPONDENTE_AFFIDATARIO.Codice \
        ORDER BY SCARICO.Numero,SCARICO.Ladata ASC";
       
	
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//		cout << result << endl;         

        return &result;
     
}


int SqlConnection::queryEsisteCaricoAssociato(SqlInt anno,SqlInt numero){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	int numrighe,valreturn;
	String query = "SELECT * FROM CORRISPONDENZA WHERE \
	CORRISPONDENZA.Anno_scarico=" + anno + \
	" AND CORRISPONDENZA.Numero_scarico=" + numero;
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
    if (numrighe>0) valreturn=1;
    else valreturn=0;
    mysql_free_result(res);
//	cout << valreturn << endl;
    return valreturn;
}

SqlResult* SqlConnection::queryInfoCALista(SqlString D1, SqlString D2){
	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	String query="SELECT Denominaz1,Denominaz2,Tipo,Codice FROM ";
        query+="CORRISPONDENTE_AFFIDATARIO WHERE Obsoleto='VALIDO'";
	
        if(D1.isNull()==false)
            query=query+" AND Denominaz1="+D1.sql();

        if(D2.isNull()==false)
            query=query+" AND Denominaz2="+D2.sql();
	
	query+=" ORDER BY Denominaz1,Denominaz2 ASC";
	
        mySqlQuery(query);
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//		cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryInfoCA(SqlInt codice){

    lock();
	char* erroreauto="non autorizzato";
	 if (!lettura) sqlException(GenericError(erroreauto));

int numrighe;
int tipo=0;

	String query = "SELECT * FROM CORRISP_ORGANIZZAZIONE WHERE \
	Codice=" + codice.sql();
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
    if (numrighe==1) tipo=1;
    mysql_free_result(res);

    query = "SELECT * FROM CORRISP_PERSONA WHERE \
	Codice=" + codice.sql();
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
    if (numrighe==1) tipo=2;
    mysql_free_result(res);

	query = "SELECT * FROM DIPENDENTE_INFO_AGG WHERE \
	Codice_dip=" + codice.sql();
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
    if (numrighe==1) tipo=3;
    mysql_free_result(res);

	if (tipo==0) {query = "SELECT CORRISPONDENTE_AFFIDATARIO.Codice, \
		CORRISPONDENTE_AFFIDATARIO.Denominaz1,CORRISPONDENTE_AFFIDATARIO.Denominaz2, \
		CORRISPONDENTE_AFFIDATARIO.Tipo,CORRISPONDENTE_AFFIDATARIO.Via, \
		CORRISPONDENTE_AFFIDATARIO.Citta,CORRISPONDENTE_AFFIDATARIO.CAP, \
		CORRISPONDENTE_AFFIDATARIO.Telefono,CORRISPONDENTE_AFFIDATARIO.FAX \
		FROM CORRISPONDENTE_AFFIDATARIO WHERE CORRISPONDENTE_AFFIDATARIO.Codice=" +
		codice.sql();}

	if (tipo==1) {query = "SELECT CORRISPONDENTE_AFFIDATARIO.Codice, \
		CORRISPONDENTE_AFFIDATARIO.Denominaz1,CORRISPONDENTE_AFFIDATARIO.Denominaz2, \
		CORRISPONDENTE_AFFIDATARIO.Tipo,CORRISPONDENTE_AFFIDATARIO.Via, \
		CORRISPONDENTE_AFFIDATARIO.Citta,CORRISPONDENTE_AFFIDATARIO.CAP, \
		CORRISPONDENTE_AFFIDATARIO.Telefono,CORRISPONDENTE_AFFIDATARIO.FAX, \
		CORRISP_ORGANIZZAZIONE.Partita_IVA,CORRISP_ORGANIZZAZIONE.Tramite \
		FROM CORRISPONDENTE_AFFIDATARIO,CORRISP_ORGANIZZAZIONE WHERE \
		CORRISPONDENTE_AFFIDATARIO.Codice=CORRISP_ORGANIZZAZIONE.Codice AND \
		CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();}

	if (tipo==2) {query = "SELECT CORRISPONDENTE_AFFIDATARIO.Codice, \
		CORRISPONDENTE_AFFIDATARIO.Denominaz1,CORRISPONDENTE_AFFIDATARIO.Denominaz2, \
		CORRISPONDENTE_AFFIDATARIO.Tipo,CORRISPONDENTE_AFFIDATARIO.Via, \
		CORRISPONDENTE_AFFIDATARIO.Citta,CORRISPONDENTE_AFFIDATARIO.CAP, \
		CORRISPONDENTE_AFFIDATARIO.Telefono,CORRISPONDENTE_AFFIDATARIO.FAX, \
		CORRISP_PERSONA.Titolo,CORRISP_PERSONA.Cod_fisc \
		FROM CORRISPONDENTE_AFFIDATARIO,CORRISP_PERSONA WHERE \
		CORRISPONDENTE_AFFIDATARIO.Codice=CORRISP_PERSONA.Codice AND \
		CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();}

	if (tipo==3) {query = "SELECT CORRISPONDENTE_AFFIDATARIO.Codice, \
		CORRISPONDENTE_AFFIDATARIO.Denominaz1,CORRISPONDENTE_AFFIDATARIO.Denominaz2, \
		CORRISPONDENTE_AFFIDATARIO.Tipo,CORRISPONDENTE_AFFIDATARIO.Via, \
		CORRISPONDENTE_AFFIDATARIO.Citta,CORRISPONDENTE_AFFIDATARIO.CAP, \
		CORRISPONDENTE_AFFIDATARIO.Telefono,CORRISPONDENTE_AFFIDATARIO.FAX, \
		DIPENDENTE_INFO_AGG.Ufficio \
		FROM CORRISPONDENTE_AFFIDATARIO,DIPENDENTE_INFO_AGG WHERE \
		CORRISPONDENTE_AFFIDATARIO.Codice=DIPENDENTE_INFO_AGG.Codice_dip AND \
		CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();}

        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//		cout << result << endl;         

        unlock();
        return &result;


}

int SqlConnection::querySePossiedeCarichi(SqlInt codice){

	char* erroreauto="non autorizzato";
	if (!lettura) sqlException(GenericError(erroreauto));

	int numrighe,valreturn;
	String query = "SELECT * FROM AFFIDAMENTO WHERE \
	AFFIDAMENTO.Codice_affidatario=" + codice.sql() + \
	" AND ISNULL(AFFIDAMENTO.Data_fine_aff)";
	mySqlQuery(query);
	myStoreResult();
    numrighe=mysql_num_rows(res);
	cout << numrighe << endl;
    if (numrighe>0) valreturn=1;
    else valreturn=0;
    mysql_free_result(res);
//	cout << valreturn << endl;
    return valreturn;
}

SqlResult* SqlConnection::queryCarichiPosseduti(SqlInt codice){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	String query = "SELECT CARICO.Anno,CARICO.Numero,CARICO.Oggetto \
	FROM AFFIDAMENTO,CARICO WHERE \
	AFFIDAMENTO.Codice_affidatario=" + codice.sql() +
	"AND CARICO.Anno=AFFIDAMENTO.Anno_carico AND CARICO.Numero=\
	AFFIDAMENTO.Numero_carico AND ISNULL(AFFIDAMENTO.Data_fine_aff)\
	ORDER BY CARICO.Anno,CARICO.Numero ASC" ;
	mySqlQuery(query);
	myStoreResult();
	result.store(res);      
	cout << "table(" << result.rowNum() << ", " << 
	result.colNum() << "): " << result.size() << " bytes" << endl;
//	cout << result << endl;         
	return &result;
}

SqlResult* SqlConnection::queryOperazioniCompiute(SqlDate predata,
	SqlDate postdata){

	char* erroreauto="non autorizzato";
 	if (!lettura) sqlException(GenericError(erroreauto));

	String query = "SELECT CORRISPONDENTE_AFFIDATARIO.Denominaz1,\
	CORRISPONDENTE_AFFIDATARIO.Denominaz2, OPERAZIONE.Data_operazione, \
	OPERAZIONE.Tipo_operazione \
	FROM CORRISPONDENTE_AFFIDATARIO, OPERAZIONE WHERE OPERAZIONE.Data_operazione >=" + 
	predata.sql() + " AND OPERAZIONE.Data_operazione <=" + postdata.sql() + 
	"AND OPERAZIONE.Codice_operatore=CORRISPONDENTE_AFFIDATARIO.Codice \
	ORDER BY OPERAZIONE.Data_operazione ASC" ;
	mySqlQuery(query);
	myStoreResult();
	result.store(res);      
	cout << "table(" << result.rowNum() << ", " << 
	result.colNum() << "): " << result.size() << " bytes" << endl;
//	cout << result << endl;         
	return &result;

}

SqlResult* SqlConnection::queryInfoCaricoMod(SqlInt anno,SqlInt numero){
	String query = "SELECT CARICO.Ladata,CARICO.Oggetto,\
	CARICO.Tipo_documento,CARICO.Riparto,CARICO.Mittente, \
	CARICO.Data_atto, CARICO.Num_atto,CARICO.Data_fax \
	FROM CARICO WHERE \
	CARICO.anno =  " + anno.sql() +" AND CARICO.numero = "
	+ numero.sql() + 
	" ORDER BY CARICO.Numero,CARICO.Ladata ASC";
                 
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//      cout << result << endl;         

        return &result;
}

SqlResult* SqlConnection::queryInfoScaricoMod(SqlInt anno,SqlInt numero){
	String query = "SELECT SCARICO.Ladata,SCARICO.Oggetto,\
        SCARICO.Tipo_documento,SCARICO.Classifica,SCARICO.Destinatario,\
        CORRISPONDENZA.Anno_carico,CORRISPONDENZA.Numero_carico, \
		SCARICO_INFO_OPZ.Annotazioni FROM CORRISPONDENTE_AFFIDATARIO,\
        SCARICO LEFT JOIN SCARICO_INFO_OPZ ON \
        SCARICO.Numero=SCARICO_INFO_OPZ.Numero AND SCARICO.Anno=SCARICO_INFO_OPZ.Anno \
        LEFT JOIN CORRISPONDENZA ON \
        CORRISPONDENZA.Anno_scarico=SCARICO.Anno AND \
		CORRISPONDENZA.Numero_scarico=SCARICO.Numero\
        WHERE SCARICO.Anno=" + anno.sql() +" AND SCARICO.Numero=" + numero.sql()
        + "AND SCARICO.Destinatario=CORRISPONDENTE_AFFIDATARIO.Codice \
        ORDER BY SCARICO.Numero,SCARICO.Ladata ASC";
	
        mySqlQuery(query);
                
        myStoreResult();
        result.store(res);      
        
        cout << "table(" << result.rowNum() << ", " << 
                result.colNum() << "): " << result.size() << " bytes" << endl;
//		cout << result << endl;         

        return &result;
}

void SqlConnection::modCarico(SqlInt anno,SqlInt numero,SqlDate data,SqlString oggetto,
                SqlString tipoDoc, SqlString riparto, SqlInt mittente, 
                SqlDate dataAtto, SqlString numeroAtto, SqlDate dataFax){

    lock();
	char* erroreauto="non autorizzato";
 	if (!modifica) sqlException(GenericError(erroreauto));

	int effectrow;
char* erroreop="operazione non avvenuta";
int numrighe;
bool foreignkey = true;
char *errorefk="Mancata corrispondenza della chiave esterna";
    
	String query = "SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" 
		+ mittente.sql();
                
        mySqlQuery(query);

        myStoreResult(); 

    numrighe=mysql_num_rows(res);
    if (numrighe!=1) foreignkey=false;
        mysql_free_result(res);
        
        query = "SELECT * FROM RIPARTO WHERE Codice=" + riparto.sql();
                
        mySqlQuery(query);

    myStoreResult(); 

    numrighe=mysql_num_rows(res);
    if (numrighe!=1) foreignkey=false;
        mysql_free_result(res);
        if (foreignkey==true){ 
               
                query = "update CARICO set Anno=" +anno.sql() + "," +" Ladata="
                + data.sql() + "," + " Oggetto=" + oggetto.sql() + "," +
                " Tipo_documento="  + tipoDoc.sql() + "," + " Riparto="
                + riparto.sql() + "," + " Mittente=" + mittente.sql() + "," +
                " Data_atto=" + dataAtto.sql() + "," + " Num_atto=" + 
                numeroAtto.sql() + "," + " Data_fax=" + dataFax.sql() + 
                " where CARICO.Anno=" +anno.sql() + "and CARICO.Numero=" + numero.sql();
                
                mySqlQuery(query);

                effectrow=mysql_affected_rows(&mysql);
				if(effectrow<=0) sqlException(GenericError(erroreop));
        }
        else sqlException(GenericError(errorefk));

   unlock();
}

void SqlConnection::modScarico(SqlInt anno, SqlInt numero, SqlDate data,
		SqlString oggetto, SqlString tipoDoc, SqlString classifica,
		SqlInt destinatario, SqlString annotazioni, SqlInt anno_carico,
		SqlInt numero_carico) {

    lock();
    if(!modifica) sqlException(GenericError("non autorizzato"));

    int effectrow, i;
    char* erroreop="operazione non avvenuta";
    bool foreignkey = true;
    String query;

    // Controlla che anno e numero puntino a uno scarico realmente esistente
    query="SELECT * FROM SCARICO WHERE Anno="+anno.sql()+" and Numero="+numero.sql();
    mySqlQuery(query);
    myStoreResult(); 
    if(mysql_num_rows(res)!=1) foreignkey=false;
    mysql_free_result(res);
        
    // Controlla che il codice del riparto sia realmente esistente
    if(!classifica.isNull()) {
        query="SELECT * FROM RIPARTO WHERE Codice="+classifica.sql();
        mySqlQuery(query);
        myStoreResult(); 
        if(mysql_num_rows(res)!=1) foreignkey=false;
        mysql_free_result(res);
    }

    // Controlla che il codice del destinatario sia realmente esistente
    if(destinatario!=null) {
        query="SELECT * FROM CORRISPONDENTE_AFFIDATARIO WHERE Codice=" 
              + destinatario.sql();
        mySqlQuery(query);
        myStoreResult(); 
        if(mysql_num_rows(res)!=1) foreignkey=false;
        mysql_free_result(res);
    }

    // Controlla che anno_carico e numero_carico puntino a un carico realmente
    // esistente
    if((!anno_carico.isNull())||(!numero_carico.isNull())) {
        query="SELECT * FROM CARICO WHERE Anno="+anno_carico.sql()+" and Numero="
              +numero_carico.sql();
        mySqlQuery(query);
        myStoreResult(); 
        if(mysql_num_rows(res)!=1) foreignkey=false;
        mysql_free_result(res);
    }
    
    // Se qualche controllo e` fallito, allora genera un errore ed esce
    if(foreignkey!=true){ 
        sqlException(GenericError("Mancata corrispondenza di una chiave"));
        return;
    }

    // Se e` tutto OK, allora procede all'aggiornamento
    query="update SCARICO set Ladata=" + data.sql() + ","
          + " Oggetto=" + oggetto.sql() + "," + " Tipo_documento="
          + tipoDoc.sql() + "," + " Classifica=" + classifica.sql() + ","
          + " Destinatario=" + destinatario.sql() + " where SCARICO.Anno="
          + anno.sql() + " and SCARICO.Numero=" + numero.sql();
    mySqlQuery(query);
    effectrow=mysql_affected_rows(&mysql);
    if(effectrow<=0) sqlException(GenericError(erroreop));
    // Controlla se gia` esistono annotazioni e decide il da farsi di conseguenza
    query="SELECT * FROM SCARICO_INFO_OPZ WHERE Anno="+anno.sql()
          +" and Numero="+numero.sql();
    mySqlQuery(query);
    myStoreResult(); 
    i=mysql_affected_rows(&mysql);
    mysql_free_result(res);
    if(i>0) {
        if(!annotazioni.isNull()) query="update SCARICO_INFO_OPZ set Annotazioni="
            +annotazioni.sql()+" where Anno="+anno.sql()+" and Numero="+numero.sql();
        else query="delete from SCARICO_INFO_OPZ where Anno="+anno.sql()
            +" and Numero="+numero.sql();
        mySqlQuery(query);
        effectrow=mysql_affected_rows(&mysql);
        if(effectrow<0) sqlException(GenericError(erroreop));
    }
    if((i==0)&&(!annotazioni.isNull())) {
        query="insert into SCARICO_INFO_OPZ values("+anno.sql()+","
            +numero.sql()+","+annotazioni.sql()+")";
        mySqlQuery(query);
        effectrow=mysql_affected_rows(&mysql);
        if(effectrow<=0) sqlException(GenericError(erroreop));
    }
    // Infine, aggiorna la tabella CORRISPONDENZA
    query="SELECT * FROM CORRISPONDENZA WHERE Anno_scarico="+anno.sql()
          +" and Numero_scarico="+numero.sql();
    mySqlQuery(query);
    myStoreResult(); 
    i=mysql_affected_rows(&mysql);
    mysql_free_result(res);
    if((anno_carico!=null)&&(numero_carico!=null)) {
	if(i>0) query="update CORRISPONDENZA set Anno_carico="+anno_carico.sql()
            +", Numero_carico="+numero_carico.sql()+" where Anno_scarico="
            +anno.sql()+" and Numero_scarico="+numero.sql();
	if(i==0) query="insert into CORRISPONDENZA values("+anno.sql()+","
            +numero.sql()+","+anno_carico.sql()+","+numero_carico.sql()+")";
        mySqlQuery(query);
        effectrow=mysql_affected_rows(&mysql);
        if(effectrow<0) sqlException(GenericError(erroreop));
    }
    if((anno_carico==null)&&(numero_carico==null)&&(i>0)) {
        query="delete from CORRISPONDENZA where Anno_scarico="
            +anno.sql()+" and Numero_scarico="+numero.sql();
        mySqlQuery(query);
        effectrow=mysql_affected_rows(&mysql);
        if(effectrow<=0) sqlException(GenericError(erroreop));
    }
    unlock();
}

void SqlConnection::modRiparto(SqlString Codice, SqlString Significato) {
	char erroreop[]="Operazione fallita";
	char errorefk[]="Riparto inesistente o piu` di un riparto";

    lock();
	String query="SELECT * FROM RIPARTO WHERE Codice="+Codice.sql();
        mySqlQuery(query);
        myStoreResult(); 

	int numrighe=mysql_num_rows(res);
        mysql_free_result(res);
	if(numrighe==1) {
		query="UPDATE RIPARTO SET Significato="+Significato.sql()
	              +" WHERE Codice="+Codice.sql();
		mySqlQuery(query);
		
		if(mysql_affected_rows(&mysql)<=0) sqlException(GenericError(erroreop));
	} else sqlException(GenericError(errorefk));

	unlock();
}

void SqlConnection::modCAOrganizzazione(SqlInt codice,SqlString Denominaz1,
	SqlString Denominaz2, SqlString Tipo, SqlString Via, SqlString Citta, 
	SqlString CAP, SqlString Telefono, 
	SqlString FAX,SqlString Piva,SqlString Tramite){

    lock();
	char* erroreauto="non autorizzato";
	if (!modifica) sqlException(GenericError(erroreauto));

	int effectrow,numrighe;
	char* erroreop="operazione non avvenuta";
	String query = "update CORRISPONDENTE_AFFIDATARIO set Denominaz1=" + Denominaz1.sql() + ","
		" Denominaz2=" + Denominaz2.sql() + "," + "Tipo=" + Tipo.sql() + "," + 
		"Via=" + Via.sql() + "," + "Citta=" + Citta.sql() + "," + "CAP=" + CAP.sql() + ","
		+ "Telefono=" + Telefono.sql() + "," + "Fax=" + FAX.sql() + 
		" where CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();
	mySqlQuery(query);
		
	if ((!Piva.isNull())||(!Tramite.isNull())){
	
		query="SELECT * FROM CORRISP_ORGANIZZAZIONE WHERE \
			CORRISP_ORGANIZZAZIONE.Codice=" + codice.sql();

    	mySqlQuery(query);

    	myStoreResult();

    	numrighe=mysql_num_rows(res);
    	if (numrighe==0){
			insertCorrispOrganizzazione(codice,Piva,Tramite);
    		effectrow=mysql_affected_rows(&mysql);
			if(effectrow<=0) sqlException(GenericError(erroreop)); 
    	}
		else {
			query = "update CORRISP_ORGANIZZAZIONE set Partita_iva=" + Piva.sql() + "," +
				"Tramite=" + Tramite.sql() + " where CORRISP_ORGANIZZAZIONE.Codice=" + 
				codice.sql();
			mySqlQuery(query);
	 	}
	 }
	 unlock();
}

void SqlConnection::modCAPersona(SqlInt codice,SqlString Denominaz1,
	SqlString Denominaz2, SqlString Tipo, SqlString Via, SqlString Citta, 
	SqlString CAP, SqlString Telefono, 
	SqlString FAX,SqlString Titolo,SqlString Cod_fisc){

    lock();
	char* erroreauto="non autorizzato";
	if (!modifica) sqlException(GenericError(erroreauto));

	int effectrow,numrighe;
	char* erroreop="operazione non avvenuta";
	String query = "update CORRISPONDENTE_AFFIDATARIO set Denominaz1=" + Denominaz1.sql() + ","
		" Denominaz2=" + Denominaz2.sql() + "," + "Tipo=" + Tipo.sql() + "," + 
		"Via=" + Via.sql() + "," + "Citta=" + Citta.sql() + "," + "CAP=" + CAP.sql() + ","
		+ "Telefono=" + Telefono.sql() + "," + "Fax=" + FAX.sql() + 
		" where CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();
	mySqlQuery(query);

	if ((!Titolo.isNull())||(!Cod_fisc.isNull())){

		query="SELECT * FROM CORRISP_PERSONA WHERE \
		CORRISP_PERSONA.Codice=" + codice.sql();

   	 	mySqlQuery(query);

    	myStoreResult();

    	numrighe=mysql_num_rows(res);
    	if (numrighe==0){
		insertCorrispPersona(codice, Titolo,Cod_fisc);
    	effectrow=mysql_affected_rows(&mysql);
		if(effectrow<=0) sqlException(GenericError(erroreop)); 
    	}
		else {		
		query = "update CORRISP_PERSONA set Titolo=" + Titolo.sql() + "," +
			"Cod_fisc=" + Cod_fisc.sql() + " where CORRISP_PERSONA.Codice=" + codice.sql();
		mySqlQuery(query);
		}
	}
	unlock();
}

void SqlConnection::modCADipendente(SqlInt codice,SqlString Denominaz1,
	SqlString Denominaz2, SqlString Tipo, SqlString Via, SqlString Citta, 
	SqlString CAP, SqlString Telefono, 
	SqlString FAX,SqlString Ufficio){

    lock();
	char* erroreauto="non autorizzato";
	if (!modifica) sqlException(GenericError(erroreauto));
 
	int effectrow,numrighe;
	char* erroreop="operazione non avvenuta";

	String query = "update CORRISPONDENTE_AFFIDATARIO set Denominaz1=" + Denominaz1.sql()+ "," +
		" Denominaz2=" + Denominaz2.sql() +
		 //"," + "Tipo=" + Tipo.sql() +
		 "," + "Tipo='dipendente'"+
         "," + "Via=" + Via.sql() + "," + "Citta=" + Citta.sql() + "," + "CAP=" + CAP.sql() + ","+
		 "Telefono=" + Telefono.sql() + "," + "Fax=" + FAX.sql() + 
		" where CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();

	mySqlQuery(query);

	if (!Ufficio.isNull()){	
	
		query="SELECT * FROM DIPENDENTE_INFO_AGG WHERE \
		DIPENDENTE_INFO_AGG.Codice_dip=" + codice.sql();

   		mySqlQuery(query);
cout << "QUIIIIIIIIIIIII" << endl;
    	myStoreResult(); 

    	numrighe=mysql_num_rows(res);
    	if (numrighe==0){
    		insertDipendenteInfoAgg( codice, Ufficio, null);
			effectrow=mysql_affected_rows(&mysql);
			if(effectrow<=0) sqlException(GenericError(erroreop)); 
    	}
		else {
		query = "update DIPENDENTE_INFO_AGG set Ufficio=" + Ufficio.sql() +
			" where DIPENDENTE_INFO_AGG.Codice_dip=" + codice.sql();
    	mySqlQuery(query);
    	}
	}
	unlock();
}

void SqlConnection::cancCA(SqlInt codice){

	char* erroreauto="non autorizzato";
	if (!cancellazione) sqlException(GenericError(erroreauto));

	int effectrow;
	char* erroreop="operazione non avvenuta";
	String query = "update CORRISPONDENTE_AFFIDATARIO set Obsoleto='SCADUTO' where \
	CORRISPONDENTE_AFFIDATARIO.Codice=" + codice.sql();
	mySqlQuery(query);
	effectrow=mysql_affected_rows(&mysql);
	if(effectrow<=0) sqlException(GenericError(erroreop)); 

}

void SqlConnection::mySqlQuery(String & query) {
        cout << query << endl;
        if (mysql_query(&mysql, query.cString()))
        exiterr(3);
}

void SqlConnection::myStoreResult() {
                if (!(res = mysql_store_result(&mysql)))
        exiterr(4);
} 

String SqlConnection::objectQuery(KeyArray & keys) {
    int count = keys.count;
    if (count < 0)
        return "";
        
    String query = " AND ( anno < -1975  ";

    for (int i = 0; i < count; ++i) 
        query += " OR (anno = " + keys.items[i].anno.sql() + " AND numero = " 
            + keys.items[i].numero.sql() + ") ";  
    query += " )";

    return query;
}
                
void SqlConnection::lock() {
     if (connected == false)
     return;

    if (lockFlag > 0) {
        lockFlag++;
        return;
    }
        

    String query = "lock tables SCARICO_INFO_OPZ write, \
                                SCARICO write,\
                                CORRISPONDENZA write, \
                                RIPARTO write, \
                                CARICO write, \
                                AFFIDAMENTO write, \
                                CORRISPONDENTE_AFFIDATARIO write, \
                                CORRISP_ORGANIZZAZIONE write, \
                                CORRISP_PERSONA write, \
                                DIPENDENTE_INFO_AGG write, \
                                OPERAZIONE write";

    mySqlQuery(query);
    lockFlag++;
}

void SqlConnection::unlock() {
    if (connected == false)
    	return;
    
    if (lockFlag > 1) {
        lockFlag--;
        return; 
    }

    String query = "unlock tables";
    mySqlQuery(query);
    lockFlag = 0;
}
