#ifndef _SQL_CONNECTION_H_
#define _SQL_CONNECTION_H_

#include "mysql.h"
#include "strings.h"
#include "exception.h"
#include "sqltypes.h"

struct DocKey {
    DocKey(){}
    DocKey(const SqlInt & _anno, const SqlInt & _numero):
        anno(_anno), numero(_numero) {}
    SqlInt anno;
    SqlInt numero;
};

struct KeyArray {
    int count;
    DocKey* items; 
};

class SqlConnection {
public:
        class GenericError: public Exception {
        public:
                GenericError(MYSQL &);
                GenericError(const GenericError & e);
        GenericError(char*);
        };
        
        SqlConnection();
        ~SqlConnection();
        void connect(const String & host, const String & user, const String & passwd);
        void disconnect();

	void initautorizzation(const String & user);

    void insertRiparto(SqlString Codice, SqlString Significato);
      
    int insertCorrispondente_affidatario( 
        SqlString Denominaz1,SqlString Denominaz2, SqlString Tipo, 
        SqlString Via, SqlString Citta, SqlString CAP, SqlString Telefono, 
        SqlString FAX, SqlString Obsoleto);

	void insertCorrispOrganizzazione(SqlInt Codice, SqlString Piva,SqlString Tramite);

    void insertCorrispPersona(SqlInt Codice, SqlString Titolo,SqlString Codfisc);

    void insertDipendenteInfoAgg(SqlInt Codice, SqlString Ufficio,
        SqlString Autorizzazione);
        
    SqlInt insertCarico(SqlInt anno, SqlDate data, SqlString oggetto,
                SqlString tipoDoc, SqlString riparto, SqlInt mittente, 
                SqlDate dataAtto, SqlString numeroAtto, SqlDate dataFax);

    SqlInt insertScarico(SqlInt anno, SqlDate data, SqlString oggetto,
                SqlString tipoDoc, SqlString classifica, SqlInt destinatario,
                SqlString annotazioni);

	void insertCorrispondenza(SqlInt annoscarico, SqlInt numeroscarico,
                SqlInt annocarico, SqlInt numerocarico);

	void insertAffidamento (SqlInt annocarico, SqlInt numerocarico,
                SqlInt codiceaffidatario, SqlDate datainizioaff);

	void insertFineAffidamento (SqlInt annocarico, SqlInt numerocarico,
                SqlDate datafineaff);

	void insertOperazione(SqlInt codiceoperatore, SqlDate dataoperazione,
                SqlInt oraoperazione,SqlString tipooperazione);

	void insertUtente(SqlInt codice,SqlString password,SqlString autorizzazioni);

	SqlResult* queryCaricoChiave(SqlInt preanno,SqlInt postanno, SqlInt prenumero, 
                SqlInt postnumero);

	SqlResult* queryScaricoChiave(SqlInt preanno,SqlInt postanno, SqlInt prenumero, 
                SqlInt postnumero);

	SqlResult* queryPerLettera(SqlString lettera);

	SqlResult* queryPerLetteraTipo(SqlString lettera);

	SqlResult* queryOggettoCarico();

	SqlResult* queryOggettoScarico();

	SqlResult* queryCorrispondenza(SqlInt anno,SqlInt numero);

	SqlResult* queryRiparto();

	SqlResult* queryAffidamentoFuori();

	SqlResult* queryOutCartaCarico(SqlInt anno);

	SqlResult* queryOutCartaScarico(SqlInt anno);

	SqlResult* queryCarico(SqlInt preanno, SqlInt postanno, SqlInt prenumero, SqlInt postnumero,
	SqlDate predata, SqlDate postdata, SqlString riparto, SqlInt mittente, KeyArray & array);

	SqlResult* queryScarico(SqlInt preanno, SqlInt postanno, SqlInt prenumero, SqlInt postnumero,
	SqlDate predata, SqlDate postdata, SqlString riparto, SqlInt mittente, KeyArray & array);

	SqlResult* queryAutorizzazioni(SqlInt login);
		/* da omettere login nel caso in cui le autorizzazioni si gestiscono da DB */

	bool autorizzato_lettura();

	bool autorizzato_inserimento();

	bool autorizzato_modifica();

	bool autorizzato_cancellazione();


	SqlResult* queryPadreScarico(SqlInt anno,SqlInt numero);

	SqlResult* queryInfoCarico(SqlInt anno,SqlInt numero);

	int queryEsisteScaricoAssociato(SqlInt anno,SqlInt numero);

	int queryEsisteAffidamento(SqlInt anno,SqlInt numero);

	SqlResult* queryInfoScarico(SqlInt anno,SqlInt numero);

	int queryEsisteCaricoAssociato(SqlInt anno,SqlInt numero);

	SqlResult* queryInfoCA(SqlInt codice);


	SqlResult* SqlConnection::queryInfoCALista(SqlString D1, SqlString D2);


	int querySePossiedeCarichi(SqlInt codice);

	SqlResult* queryCarichiPosseduti(SqlInt codice);

	SqlResult* queryOperazioniCompiute(SqlDate predata,SqlDate postdata);

	SqlResult* queryInfoCaricoMod(SqlInt anno,SqlInt numero);

	SqlResult* queryInfoScaricoMod(SqlInt anno,SqlInt numero);

	void modCarico(SqlInt anno,SqlInt numero,SqlDate data,SqlString oggetto,
                SqlString tipoDoc, SqlString riparto, SqlInt mittente, 
                SqlDate dataAtto, SqlString numeroAtto, SqlDate dataFax);

	void modScarico(SqlInt anno, SqlInt numero, SqlDate data, SqlString oggetto,
                SqlString tipoDoc, SqlString classifica, SqlInt destinatario, 
                SqlString annotazioni, SqlInt anno_carico, SqlInt numero_carico);

	void SqlConnection::modRiparto(SqlString Codice, SqlString Significato);

	void modCAOrganizzazione(SqlInt codice,SqlString Denominaz1,SqlString Denominaz2, SqlString Tipo, 
        SqlString Via, SqlString Citta, SqlString CAP, SqlString Telefono, 
        SqlString FAX,SqlString Piva,SqlString Tramite);

	void modCAPersona(SqlInt codice,SqlString Denominaz1,
		SqlString Denominaz2, SqlString Tipo, SqlString Via, SqlString Citta, 
		SqlString CAP, SqlString Telefono, 
		SqlString FAX,SqlString Titolo,SqlString Cod_fisc);

	void modCADipendente(SqlInt codice,SqlString Denominaz1,
		SqlString Denominaz2, SqlString Tipo, SqlString Via, SqlString Citta, 
		SqlString CAP, SqlString Telefono, 
		SqlString FAX,SqlString Ufficio);

	void cancCA(SqlInt codice);

	int progressivoCarico(SqlInt anno);

	int progressivoScarico(SqlInt anno);

    void lock();
    void unlock();                

private:
		bool lettura;
		bool scrittura;
		bool modifica;
		bool cancellazione;
		int lockFlag;
	
	bool connected;	
        MYSQL mysql;
        MYSQL_RES *res;
        MYSQL_ROW row;
        SqlResult result;
		String nameDB; 
		String nameUser;
//		void exiterr(int exitcode);
        void mySqlQuery(String & query);
        void myStoreResult();   

        String objectQuery(KeyArray & keys);
};

#endif

