#include "sqltypes.h"
#include <stdio.h>

char monthDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

Null null;

bool SqlType::isNull() const{
	return null;
}

bool SqlType::operator == (Null _null) const {
    return null;
}

SqlInt::SqlInt(Null _value) {
	null = true;
}

SqlInt::SqlInt(int _value) {
	value = _value;
	null = false;
}

SqlInt::SqlInt(const String & _value) {
	if ((_value == "") || (_value == "null")) {
		null = true;
		return;
	} 

	value = _value.asInt();
}

SqlInt::SqlInt(const char* _value) {
    if (_value == NULL) {
        null = true;
        return;
    }

    String conv(_value);
	if ((conv == "") || (conv == "null")) {
		null = true;
		return;
	} 

    null = false;
	value = conv.asInt();
}

String SqlInt::sql() const {
	return (null == true) ? "null" : "'"+String(value)+"'";
}

String SqlInt::html() const {
	return (null == true) ? "" : String(value);
}

SqlInt::operator String() {
	return (null == true) ? "null" : String(value);
}

bool SqlInt::operator == (const SqlInt & other) const {
	if (null)
		return other.null;

	return value == other.value;
}

bool SqlInt::operator <= (const SqlInt & other) const{
	if (null)
		return other.null;

	return value <= other.value;
}

bool SqlInt::operator >= (const SqlInt & other) const{
	if (null)
		return other.null;

	return value >= other.value;
}

bool SqlInt::operator < (const SqlInt & other) const{
	if (null)
		return false;

	return value < other.value;
}

bool SqlInt::operator > (const SqlInt & other) const{
	if (null)
		return false;

	return value > other.value;
}

bool SqlInt::operator != (const SqlInt & other) const{
	if (null)
		return other.null == false;

	return value != other.value;
}

SqlInt & SqlInt::operator += (const SqlInt & other) {
	if (other.null || null) 
		null = true; 
	else	
		value += other.value;

	return *this;
}

SqlInt & SqlInt::operator -= (const SqlInt & other) {
	if (other.null || null) 
		null = true; 
	else
		value -= other.value;

	return *this;
}

SqlInt SqlInt::operator + (const SqlInt & other) {
	if (other.null || null) 
		return SqlInt(::null); 
	else	
		return SqlInt(value + other.value);
}

SqlInt SqlInt::operator - (const SqlInt & other) {
	if (other.null || null) 
		return SqlInt(::null); 
	else	
		return SqlInt(value - other.value);
}

SqlInt & SqlInt::operator ++ () {
	value++;
	return *this;
}

SqlInt &  SqlInt::operator -- () {
	value--;
	return *this;
}

DateFormat SqlDate::format = italian;

SqlDate::SqlDate(Null _null) {
	null = true;
}

SqlDate::SqlDate(int _year, int _month, int _day) {
	year = _year;
	month = _month;
	day = _day;
}

SqlDate::SqlDate(const String & _value) {	
	int n;
	char tmp[40];

    if (format == italian) {
    	strcpy(tmp, _value.cString());
	    n = sscanf(tmp, "%d/%d/%d", &day, &month, &year);
	    if ((n == 3) && checkSense())  
		  return;

	    strcpy(tmp, _value.cString());
	    n = sscanf(tmp, "%d-%d-%d", &day, &month, &year);
	    if ((n == 3) && checkSense())  
		  return;

    }
    else {
    	strcpy(tmp, _value.cString());
	    n = sscanf(tmp, "%d/%d/%d", &year, &month, &day);
	    if ((n == 3) && checkSense())  
		  return;

	    strcpy(tmp, _value.cString());
	    n = sscanf(tmp, "%d-%d-%d", &year, &month, &day);
	    if ((n == 3) && checkSense())  
		  return;
    }
    
    throw ConversionError("Formato di data scorretto in " + _value);		
}

SqlDate::SqlDate(const char* _value) {	
    if (_value == NULL) {
        null = true;
        return;
    }

	int n;
	char tmp[40];

    if (format == italian) {
    	strcpy(tmp, _value);
	    n = sscanf(tmp, "%d/%d/%d", &day, &month, &year);
	    if ((n == 3) && checkSense())  
		  return;

	    strcpy(tmp, _value);
	    n = sscanf(tmp, "%d-%d-%d", &day, &month, &year);
	    if ((n == 3) && checkSense())  
		  return;

    }
    else {
    	strcpy(tmp, _value);
	    n = sscanf(tmp, "%d/%d/%d", &year, &month, &day);
	    if ((n == 3) && checkSense())  
		  return;

	    strcpy(tmp, _value);
	    n = sscanf(tmp, "%d-%d-%d", &year, &month, &day);
	    if ((n == 3) && checkSense())  
		  return;
    }
    
	throw ConversionError("Formato di data scorretto in " + String(_value));		
}

String SqlDate::sql() const {
	return (null == true) ? "null" : "'"+String(year)+"-"+String(month)+"-"+String(day)+"'";
}

String SqlDate::html() const {
	return (null == true) ? "" : String(day)+"/"+String(month)+"/"+String(year);
}

SqlDate::operator String() {
	return (null == true) ? "null" : String(day)+"/"+String(month)+"/"+String(year);
}

bool SqlDate::operator == (const SqlDate & other) const {
	if (null)
		return other.null;

	return ((year == other.year) && (month == other.month) 
		&& (day == other.day));
}

bool SqlDate::operator <= (const SqlDate & other) const {
	if (null)
		return other.null;

	if (year < other.year)
		return true;
	else
	if (year > other.year)
		return false;

	if (month < other.month)
		return true;
	else
	if (month > other.month)
		return false;

	if (day < other.day)
		return true;
	else
	if (day > other.day)
		return false;

	return true;
}

bool SqlDate::operator >= (const SqlDate & other) const {
	if (null)
		return other.null;

	if (year > other.year)
		return true;
	else
	if (year < other.year)
		return false;

	if (month > other.month)
		return true;
	else
	if (month < other.month)
		return false;

	if (day > other.day)
		return true;
	else
	if (day < other.day)
		return false;

	return true;
}

bool SqlDate::operator < (const SqlDate & other) const {
	if (year < other.year)
		return true;
	else
	if (year > other.year)
		return false;

	if (month < other.month)
		return true;
	else
	if (month > other.month)
		return false;

	if (day < other.day)
		return true;
	else
	if (day > other.day)
		return false;

	return false;
}

bool SqlDate::operator > (const SqlDate & other) const {
	if (null)
		return other.null;

	if (year > other.year)
		return true;
	else
	if (year < other.year)
		return false;

	if (month > other.month)
		return true;
	else
	if (month < other.month)
		return false;

	if (day > other.day)
		return true;
	else
	if (day < other.day)
		return false;

	return false;
}

bool SqlDate::operator != (const SqlDate & other) const {
	if (null)
		return other.null;

	return ((year == other.year) && (month == other.month) 
		&& (day == other.day));
}


SqlDate & SqlDate::operator ++ () {
	day++;

	if (day > monthDays[month-1]) {		// passa ad un nuovo mese
		day = 1;
		month++;
	}
		
	if (month > 12) {					// passa ad un nuovo anno
		month = 1;
		year++;
	}
	
	if ((day == 1) && (month == 3) && ((year % 4) == 0)) {	// anno bisestile
		day = 29;
		month = 2;
	}
	
	return *this;
}

bool SqlDate::checkSense() {
	if (year < 0)
		return false;
	
	if (((year % 4) == 0) && (month == 2) && (day == 29))
		return true;

	if ((month < 1) || (month > 12))
		return false;

	if ((day < 1) || (day > monthDays[month-1]))
		return false;

	return true;
}

SqlString::SqlString(Null _null) {
	null = true;
}

SqlString::SqlString(const String & _value): value(_value) {
	null = false;
}

SqlString::SqlString(const char* _value) {
    if (_value == NULL) {
        null = true;
        return;
    }

    value = String(_value);
	null = false;
}

String SqlString::sql() const {
	if (null == true) return "null";

    char* cs = value.cString();

    int newSize = 0;
    for (int i = 0; cs[i] != 0; ++i, ++newSize)
        if (cs[i] == '\'') newSize += 2;

    char* ns = new char[newSize+5];

    ns[0] = '\'';
    int j = 1;
    for (int i = 0; cs[i] != 0; ++i, ++j) {
        if (cs[i] == '\'') 
            ns[j++] = '\\';
            
        ns[j] = cs[i];
    }       
    ns[j++] = '\'';
    ns[j] = 0;
    
	String res(ns);
	delete[] ns;
	return res;
}

String SqlString::html() const {
	return (null == true) ? "" : value;
}

SqlString::operator String() {
	return (null == true) ? "null" : value;
}

SqlResult::SqlResult() {
    rowNumber = 0;
    colNumber = 0;
    totalSize = 0;
    
    table = NULL;
}

SqlResult::~SqlResult() {
    reset();
}

void SqlResult::store(MYSQL_RES *res) {
    reset();

	rowNumber = mysql_num_rows(res);
	colNumber = mysql_num_fields(res);

	createTable(res);

	mysql_free_result(res);
}

char* SqlResult::attribute(int col) {
    return header[col];
}

void SqlResult::reset() {
    if (table == NULL) return;
        
    for (int i=0; i < rowNumber; ++i) {
	    for (int j=0 ; j < colNumber; j++) {
			if(table[i][j]!=NULL) delete table[i][j];
	    }
	    delete[] table[i];		
    }
    delete[] table;

    table = NULL;

    if (header == NULL) return;
    for (int j=0 ; j < colNumber; j++) 
		delete header[j];
    delete[] header;

    header = NULL;
    
}

SqlResult& SqlResult::operator=(const SqlResult& sqlr) {	
	// se stiamo copiando l'oggetto su se stesso,
	// non dobbiamo in pratica fare nulla!
	if (this==&sqlr) return *this;
	
	// liberiamo tutta la memoria associata all'oggetto
	reset();
	
	// copiamo tutta la memoria dell'oggetto sorgente
	rowNumber = sqlr.rowNumber;
	colNumber = sqlr.colNumber;
	totalSize = sqlr.totalSize;

    header = new (char*)[colNumber];
    for (int j=0; j < colNumber; ++j) {
        int len = strlen(sqlr.header[j]);
        header[j] = new char[len+1];
        strcpy(header[j], sqlr.header[j]);
    }

	table = new (char**)[rowNumber];
	int i, j, len;
	
	for (i=0; i < rowNumber; i++) {
		table[i] = new (char*)[colNumber];
		for (j=0 ; j < colNumber; j++) {
		        if (sqlr.table[i][j]==NULL) {
				table[i][j] = NULL;
			} else {
				len = strlen(sqlr.table[i][j]);
				table[i][j] = new char[len+1];
				// speriamo che la memoria ci sia...
				strcpy(table[i][j], sqlr.table[i][j]);
			}
		}
        }
	return *this;
}



void SqlResult::createTable(MYSQL_RES *res) {
	MYSQL_ROW row;
	MYSQL_FIELD* field;
	totalSize = 0;
	table = new (char**)[rowNumber];
    header = new (char*)[colNumber];

// crea l'header
    for (int i=0; i < colNumber; ++i) {
        field = mysql_fetch_field(res); 
        int len = strlen(field->name);
        header[i] = new char[len+1];
        strcpy(header[i], field->name); 
    }
	
	for (int i=0; i < rowNumber; ++i) {
		row = mysql_fetch_row(res);
		table[i] = new (char*)[colNumber];
		for (int j=0 ; j < colNumber; j++) {
			if (row[j] == NULL) {
				table[i][j] = NULL;
				totalSize += NULLSIZE;
				
				continue;
			}

			int len = strlen(row[j]);
			table[i][j] = new char[len+1];
			strcpy(table[i][j], row[j]);
			totalSize += len;

		}
    }
}

int SqlResult::rowNum() {
	return rowNumber;
}

int SqlResult::colNum() {
	return colNumber;
}

int SqlResult::size() {
	return totalSize;
}

char* SqlResult::get(int row, int col) {
	return table[row][col];
}

ostream & operator << (ostream & os, SqlResult & r) {
    for (int j=0; j < r.colNumber; ++j) 
        os << r.header[j] << ", ";  

    os << endl;
	for (int i=0; i < r.rowNumber; ++i) {
        os << endl; 
		for (int j=0 ; j < r.colNumber; j++) {
			os << r.table[i][j] << " , ";
		}
    }

	return os;
} 
