#ifndef _SQLTYPES_H_
#define _SQLTYPES_H_

#include "strings.h"
#include "mysql.h" 

#define NULLSIZE 1

enum DateFormat {
    italian,
    english
};

class Null {
};

extern Null null;

class SqlType {
public:
	class ConversionError: public Exception {
	public:
		ConversionError(const String& error): Exception(error){}
		ConversionError(const ConversionError& e): 
			Exception(e.description()) {}
	};
	
	bool isNull() const;
	bool operator == (Null _null) const; 

	virtual String sql() const = 0;
	virtual String html() const = 0;
	virtual operator String() = 0;
protected:
	bool null;
};

class SqlInt: public SqlType {
public:
	SqlInt(Null _null=::null);
	SqlInt(int _value);					// inizializza un intero 
	SqlInt(const String & _value);
	SqlInt(const char* _value);
	virtual ~SqlInt() {}
	
	virtual String sql() const;
	virtual String html() const;
	virtual operator String();

	bool operator == (const SqlInt & other) const; 
	bool operator <= (const SqlInt & other) const; 
	bool operator >= (const SqlInt & other) const; 
	bool operator < (const SqlInt & other) const; 
	bool operator > (const SqlInt & other) const; 
	bool operator != (const SqlInt & other) const; 
	
	SqlInt & operator += (const SqlInt & other); 
	SqlInt & operator -= (const SqlInt & other); 
	SqlInt  operator + (const SqlInt & other); 
	SqlInt  operator - (const SqlInt & other); 
	SqlInt & operator ++ (); 
	SqlInt & operator -- (); 

protected:
	int value;
};

class SqlDate: public SqlType {
public:
	SqlDate(Null _null=::null);
	SqlDate(int _year, int _month, int _day);
	SqlDate(const String & _value);
	SqlDate(const char* _value);
	virtual ~SqlDate() {}
	
	virtual String sql() const;
	virtual String html() const;
	virtual operator String();
	
	bool operator == (const SqlDate & other) const; 
	bool operator <= (const SqlDate & other) const; 
	bool operator >= (const SqlDate & other) const; 
	bool operator < (const SqlDate & other) const; 
	bool operator > (const SqlDate & other) const; 
	bool operator != (const SqlDate & other) const; 

	SqlDate & operator ++ (); 

    static DateFormat format;
protected:
	int year;
	int month;
	int day;

	bool checkSense();	
};

class SqlString:public SqlType {
public:
	SqlString(Null _null=::null);
	SqlString(const String & _value);
	SqlString(const char* _value);
	virtual ~SqlString() {}
	
	virtual String sql() const;
	virtual String html() const;
	virtual operator String();

protected:
	String value;
};

class SqlResult {
public:
	SqlResult();
	~SqlResult();
	
	SqlResult& operator=(const SqlResult&);

	void store(MYSQL_RES *res);
	char* attribute(int col);
	char* get(int row, int col);
	int rowNum();
	int colNum();
	int size();

private:
	int rowNumber;
	int colNumber;
	char** header;
	char*** table;
	int totalSize;
	
	void createTable(MYSQL_RES *res);
    void reset();

	friend ostream & operator << (ostream & os, SqlResult & r); 
};


ostream & operator << (ostream & os, SqlResult & r); 

class SqlLock {
};

#endif
