/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: bridge2.cc           ULTIMA MODIFICA: 01/07/1999        */
/*                                                                  */
/*  Gateway CGI-BIN (chiamato anche "bridge") di prova; l'unico     */
/*  scopo di questo programma e' di verificare che i parametri      */
/*  provenienti dal web server siano corretti.                      */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <stdio.h>
#include "stringone.h"
#include "html_utils.h"

int main(int argc, char *argv[]){
    testa("Informazioni di servizio");    // invia subito l'intestazione HTML

    char *buff;                           // alloca le variabili
    int l;

    buff=getenv("REQUEST_METHOD");        // controlla se il metodo e' GET o POST
    printf("REQUEST_METHOD=\"%s\"<BR>\n", buff);
    buff=getenv("CONTENT_LENGTH");        // det. lunghezza input (metodo POST)
    printf("CONTENT_LENGTH=\"%s\"<BR>\n", buff);
    buff=getenv("QUERY_STRING");
    printf("QUERY_STRING=\"%s\"<BR>\n", buff);

    printf("argc=%d<BR>\n",argc);
    for(l=0; l<argc; ++l) printf("argv[%d]=%s<BR>\n",l,argv[l]);
    
    l=leggi_input(buff);
    switch(l) {
        case 0:
            printf("Lettura dei parametri OK<BR><BR>\n");
        break;
        case 1:
            errore("Errore: la variabile d'ambiente CONTENT_LENGTH non esiste.");
            return(1);
        break;
        case 2:
            errore("Errore: CONTENT_LENGTH non contiene dati validi.");
            return(2);
        break;
        case 3:
            errore("Errore: allocazione del buffer fallita.");
            return(3);
        break;
        case 4:
            errore("Errore: la variabile d'ambiente QUERY_STRING non esiste.");
            return(4);
        break;
        case 5:
            errore("Errore: protocollo di comunicazione non riconosciuto.");
            return(5);
        break;
        default:
            errore("Errore: errore di tipo sconosciuto.");
            return(6);
        break;
    }
    printf("Dal web server ho ricevuto la stringa \"%s\"<BR>\n", buff);
    printf("<BR>\n");

    stringone big_s;
    int i;
    i=big_s.newstring(buff);
    if(i!=0) {
        errore("Errore nel passaggio dati alla classe stringone.");
        return(7);
    }

    // Stampa la lunghezza della stringa e il numero di token
    printf("La classe stringone dice che la lungh. della stringa  %d<BR>\n",
           big_s.lstr);
    printf("Il numero di token nella stringa  %d<BR>\n", big_s.numtok);

    // mostra una tabella con i singoli token
    printf("I token sono:<BR>\n");
    printf("<TABLE BORDER=2>\n");
    printf("<TR ALIGN=CENTER><TD>NOME TOKEN</TD><TD>LUNGH. NOME</TD>\n");
    printf("                 <TD>VALORE TOKEN</TD><TD>LUNGH. VALORE</TD></TR>\n");
    token* mytoken;
    for(i=1; i<=big_s.numtok; i++) {
        printf("<TR ALIGN=CENTER>\n");
        mytoken=big_s.nexttoken();
        printf("<TD>%s</TD><TD>%d</TD><TD>%s</TD><TD>%d</TD>\n",
               mytoken->name,mytoken->namelen,mytoken->value,mytoken->valuelen);
        printf("</TR>\n");
    } // fine del ciclo for
    printf("</TABLE>\n");

    // Qui bisognerebbe liberare la memoria allocata...
    // Ma "Francamente, me ne infischio!" (visto che il programma termina...)

    coda();
    return 0;
}
