#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stringone.h"

void testa() {
    printf("Content-type: text/html\n\n<HTML>\n");
    printf("<HEAD><TITLE>Prova CGI n.2</TITLE></HEAD>\n");
    printf("<BODY bgcolor=\"#FFFFFF\" text=\"#000000\">\n");
}

void coda() {
    printf("</BODY>\n");
    printf("</HTML>\n");
}

void errore(char* messaggio){          // chiude il file HTML con un errore
    printf(messaggio);
    printf("<BR>\n");
    coda();
}

int main(int argc, char *argv[]){
    testa();                           // invia subito l'intestazione HTML

    char *buff, *clength;              // alloca le variabili
    int lungh_input;
    clength = getenv("CONTENT_LENGTH");     // det. la lunghezza dell'input
    if(clength==NULL) {
        errore("Errore: la variabile d'ambiente CONTENT_LENGTH non esiste.");
        return(1);
    }
    printf("CONTENT_LENGTH=\"%s\"<BR>\n", clength);
    lungh_input=atoi(clength);
    if(lungh_input==0) {
        errore("Errore: il formato di CONTENT_LENGTH non  corretto.");
        return(2);
    }
    buff=new char[lungh_input+8];      // alloca il buffer per l'input
    if(buff==NULL) {
        errore("Errore: allocazione del buffer fallita.");
        return(3);
    }
    fread(buff, lungh_input, 1, stdin);
    buff[lungh_input]='\0';
    printf("Dal web server ho ricevuto la stringa \"%s\"<BR>\n", buff);
    printf("<BR>\n");

    stringone big_s;
    int i;
    i=big_s.newstring(buff);
    if(i!=0) {
        errore("Errore nel passaggio dati alla classe stringone.");
        return(4);
    }

    // Stampa la lunghezza della stringa e il numero di token
    printf("La classe stringone dice che la lungh. della stringa  %d<BR>\n",
           big_s.lstr);
    printf("Il numero di token nella stringa  %d<BR>\n", big_s.numtok);

    // mostra una tabella con i singoli token
    printf("I token sono:<BR>\n");
    printf("<TABLE BORDER=2>\n");
    printf("<TR ALIGN=CENTER><TD>NOME TOKEN</TD><TD>LUNGH. NOME</TD>\n");
    printf("                 <TD>VALORE TOKEN</TD><TD>LUNGH. VALORE</TD></TR>\n");
    token* mytoken;    
    for(i=1; i<=big_s.numtok; i++) {
        printf("<TR ALIGN=CENTER>\n");
        mytoken=big_s.nexttoken();
	printf("<TD>%s</TD><TD>%d</TD><TD>%s</TD><TD>%d</TD>\n",
	       mytoken->name,mytoken->namelen,mytoken->value,mytoken->valuelen);
        printf("</TR>\n");
    } // fine del ciclo for
    printf("</TABLE>\n");

    // collauda la funzione findtoken(.) cercando alcuni token
    printf("<BR>Valore di alcuni token (per collaudare findtoken):<BR>\n");
    printf("ogg=%s<BR>\n", big_s.findtoken("ogg"));
    printf("opid=%s<BR>\n", big_s.findtoken("opid"));
    printf("num=%s<BR>\n", big_s.findtoken("num"));
    printf("<BR>Per finire, un token inesistente:<BR>\n");
    printf("neoprene=%s<BR>\n", big_s.findtoken("neoprene"));
    
    coda();
    return 0;
}
