#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <except.h>

void testa() {
    printf("Content-type: text/html\n\n<HTML>\n");
    printf("<HEAD><TITLE>Prova CGI n.2</TITLE></HEAD>\n");
    printf("<BODY bgcolor=\"#FFFFFF\" text=\"#000000\">\n");
}

void coda() {
    printf("</BODY>\n");
    printf("</HTML>\n");
}

void errore(char* messaggio){          // chiude il file HTML con un errore
    printf(messaggio);
    printf("<BR>\n");
    coda();
}

int decodifica(char* buf_in, char* buf_out) {
    const int lstr=strlen(buf_in);
    if(lstr==0) return 0;    // se la stringa ha lungh. nulla, esce subito
    int i=0, j=0;
    char minibuf[3];         // mini-buffer per i codici esadecimali
    minibuf[2]='\0';
    while(i<lstr) {
        switch(buf_in[i]) {
      	   case '+':
                buf_out[j]=' ';
                i++;
                j++;
            break;
      	   case '%':
                minibuf[0]=buf_in[i+1];
                minibuf[1]=buf_in[i+2];
  	             buf_out[j]=(char)strtol(minibuf, NULL, 16);
                i=i+3;
                j++;
            break;
      	   default:
                buf_out[j]=buf_in[i];
                i++;
                j++;
            break;
        } // fine dello switch
    } // fine del ciclo while
    buf_out[j]='\0';
    return j;
}

int main(int argc, char *argv[]){
    testa();                           // invia subito l'intestazione HTML

    char *buff, *clength;              // alloca le variabili
    int lungh_input;
    clength = getenv("CONTENT_LENGTH");     // det. la lunghezza dell'input
    if(clength==NULL) {
        errore("Errore: la variabile d'ambiente CONTENT_LENGTH non esiste.");
        return(1);
    }
    printf("CONTENT_LENGTH=\"%s\"<BR>\n", clength);
    lungh_input=atoi(clength);
    if(lungh_input==0) {
        errore("Errore: il formato di CONTENT_LENGTH non  corretto.");
        return(2);
    }
    try {
        buff=new char[lungh_input+8];      // alloca il buffer per l'input
    }
    catch(xalloc) {
        errore("Errore: allocazione del buffer fallita.");
        return(2);
    }
    fread(buff, lungh_input, 1, stdin);
    buff[lungh_input]='\0';
    printf("Dal web server ho ricevuto la stringa \"%s\"<BR>\n", buff);
    printf("<BR>\n");

    // calcola il numero di token
    int i, numtok=1;
    for(i=0; i<lungh_input; i++) if(buff[i]=='&') numtok++;
    printf("Il numero di token nella stringa  %d<BR>\n", numtok);

    // separa e decodifica i singoli token
    char *buf2=new char[lungh_input+8];
    char *buf3=new char[lungh_input+8];
    int k, l;
    k=0;
    printf("I token sono:<BR>\n");
    printf("<TABLE BORDER=1>\n");
    printf("<TR ALIGN=CENTER><TD>TOKEN</TD><TD>LUNGHEZZA</TD></TR>\n");
    for(i=0; i<=lungh_input; i++) {
        if((buff[i]=='&')||(i==lungh_input)) {
            buf2[k]='\0';
            l=decodifica(buf2, buf3);
            printf("<TR ALIGN=CENTER><TD>%s</TD><TD>%d</TD></TR>\n", buf3, l);
            k=0;
        } else {
            buf2[k]=buff[i];
            k++;
        }
    } // fine del ciclo for
    printf("</TABLE>\n");

    coda();
    return 0;
}
