/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "Synapse_msgs.h"
#include "StorageVolumes.h"

//#define DEBUG_SYNAPSE
configuration SyNaPseC
{
}

implementation
{
//	components PrintfC;

	components MainC, SyNaPseP;
	SyNaPseP -> MainC.Boot;
	MainC.SoftwareInit -> SyNaPseP.Init;
	
	components ActiveMessageC;
	SyNaPseP.AMControl -> ActiveMessageC;
	
	components new Synapse_PartitionStorageC() as PartitionManager;
	SyNaPseP.Synapse_PartitionStorage -> PartitionManager.Synapse_PartitionStorage;
	SyNaPseP.BlockRead   -> PartitionManager.BlockRead;
	SyNaPseP.BlockWrite  -> PartitionManager.BlockWrite;

	//SyNaPseP.get_PartitionEntry -> PartitionManager.get_PartitionEntry;
	SyNaPseP.get_NumOfImg -> PartitionManager.get_NumOfImg;

	components RandomC as Rand;
	SyNaPseP.Random -> Rand;
	
	components SerialActiveMessageC as SerialAM;
	SyNaPseP.SerialControl -> SerialAM;
	SyNaPseP.SerialReceive -> SerialAM.Receive[AM_SYNAPSE_SERIALCOMMAND];
	SyNaPseP.SerialPingReceive -> SerialAM.Receive[AM_SYNAPSE_SERIAL_PING];
	SyNaPseP.SerialPacket  -> SerialAM;
	
	components CC2420TimeSyncMessageC as AdvSenderC;
	SyNaPseP.TimeSyncAdvPacket	-> AdvSenderC.TimeSyncPacketMilli;
	SyNaPseP.AdvPacket    -> AdvSenderC;
	SyNaPseP.AdvSend      -> AdvSenderC.TimeSyncAMSendMilli[AM_SYNAPSE_ADV];
	SyNaPseP.AdvAMPacket  -> AdvSenderC;
	components CC2420TimeSyncMessageC as AdvReceiverC;
	SyNaPseP.AdvReceive   -> AdvReceiverC.Receive[AM_SYNAPSE_ADV];

	components new AMSenderC(AM_SYNAPSE_CMD) as CmdSenderC;
	SyNaPseP.CmdPacket    -> CmdSenderC;
	SyNaPseP.CmdSend      -> CmdSenderC;
	SyNaPseP.CmdAMPacket  -> CmdSenderC;
	components new AMReceiverC(AM_SYNAPSE_CMD) as CmdReceiverC;
	SyNaPseP.CmdReceive   -> CmdReceiverC;

	components new AMSenderC(AM_SYNAPSE_PING) as PingSenderC;
	SyNaPseP.PingPacket    -> PingSenderC;
	SyNaPseP.PingSend      -> PingSenderC;
	SyNaPseP.PingAMPacket  -> PingSenderC;
	components new AMReceiverC(AM_SYNAPSE_PING) as PingReceiverC;
	SyNaPseP.PingReceive   -> PingReceiverC;
	

	components new AMSenderC(AM_SYNAPSE_REQ) as ReqSenderC;
	SyNaPseP.ReqPacket    -> ReqSenderC;
	SyNaPseP.ReqSend      -> ReqSenderC;
	SyNaPseP.ReqAMPacket  -> ReqSenderC;
	components new AMReceiverC(AM_SYNAPSE_REQ) as ReqReceiverC;
	SyNaPseP.ReqReceive   -> ReqReceiverC;

	components Synapse_RadioC;
	SyNaPseP.Synapse_Radio -> Synapse_RadioC.Synapse_Radio;

	components Synapse_BootloaderCommunicationC;
	SyNaPseP.BootloaderCommunication -> Synapse_BootloaderCommunicationC.Synapse_BootloaderCommunication;

	components LedsC;
	SyNaPseP.Leds -> LedsC;

	components new TimerMilliC() as TimerC;
	SyNaPseP.Timer -> TimerC;

	components new TimerMilliC() as TxTimerC;
	SyNaPseP.TxTimer -> TxTimerC;

	components CrcC;
	SyNaPseP.Crc -> CrcC;

	components Synapse_SerialQueueC;
	SyNaPseP.Synapse_SerialQueue -> Synapse_SerialQueueC;

	components SerialFlashManagerC;
	SerialFlashManagerC.Boot -> MainC.Boot;
	MainC.SoftwareInit -> SerialFlashManagerC.Init;
	
	#ifdef LOADABLE 
	components CC2420ControlP, ActiveMessageAddressC;
	SyNaPseP.CC2420Config -> CC2420ControlP;
	SyNaPseP.setAmAddress -> ActiveMessageAddressC;
	#endif

	#ifdef STAT
	components new LogStorageC(VOLUME_SYNAPSE_LOG, 0) as StatVolume;
	SyNaPseP.LogWrite->StatVolume;
	components new TimerMilliC() as StatTimerC;
	SyNaPseP.StatTimer -> StatTimerC;
	#endif
	
	#ifdef DEBUG_SYNAPSE	
	components DumpToLedsC;
	SyNaPseP.DumpToLeds -> DumpToLedsC;
	#endif	
}
