/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

interface Synapse_Radio
{
	
	/**
	* INIT operations
	*/
	command void initializeSend(uint8_t blockId, uint16_t seed);
	command void initializeReceive(uint8_t blockId, bool retry);

	/**
	*  SEND
	*  Return buffer and buffer size. Sender must put data to send in buffer
	*  and call sendBlock.
	*/
	command uint8_t *PASS getBuffer( uint16_t *bufferSize );

	/**
	*  Send blockId stored in buffer using blockId. When send process
	*  is comleted a sendBlockDone is signaled.
	*/
	command error_t sendBlock();

	/**
	*  Signal the end of send process.
	*/
	event void sendBlockDone(error_t err);

	/**
	*  Start reception of a block
	*/
	command error_t receiveBlock();

	/**
	*  RECEIVE
	* signals the reception of a block, if something went wrong the size will be 0
	*/
	event void receiveBlockDone(uint8_t *PASS buf, uint16_t size, uint16_t blockId, error_t error );

	/**
	*  
	*/
	//command void releaseBuffer( );
	
}
