/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "Synapse_msgs.h"
// #define DEBUG_SYNAPSE_RADIO

configuration Synapse_RadioC
{
	provides {
		interface Synapse_Radio;
	}
}

implementation
{
	components Synapse_RadioP;
	
	Synapse_Radio = Synapse_RadioP.Synapse_Radio;

	components Synapse_CodecC;
	Synapse_RadioP.Codec -> Synapse_CodecC;

	components new TimerMilliC() as Timer;
	Synapse_RadioP.Timer -> Timer;

	components RandomC;
	Synapse_RadioP.Random -> RandomC;

#ifdef DEBUG_SYNAPSE_RADIO
	components Synapse_SerialQueueC;
	Synapse_RadioP.Synapse_SerialQueue -> Synapse_SerialQueueC;

	components SerialActiveMessageC as SerialAM;
	Synapse_RadioP.SerialPacket  -> SerialAM;
#endif

	// Data msgs
	components new AMSenderC(AM_SYNAPSE_DATA) as DataSenderC;
	Synapse_RadioP.DataPacket    -> DataSenderC;
	Synapse_RadioP.DataSend      -> DataSenderC;
	Synapse_RadioP.DataAMPacket  -> DataSenderC;
	components new AMReceiverC(AM_SYNAPSE_DATA) as DataReceiverC;
	Synapse_RadioP.DataReceive   -> DataReceiverC;
	
	components new RandomLFSRC_TOS() as RandD;
	Synapse_RadioP.RandDegree -> RandD;

	components CC2420PacketC;
	Synapse_RadioP.CC2420Packet->CC2420PacketC;
}
