/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
// #define AL_TYPE
#define MSP_TYPE

generic module RandomLFSRC()
{
    provides interface Synapse_Random;
}

implementation
{
    #ifdef AL_TYPE
    static const uint16_t m_o = 0x6996;
    uint16_t m_seed = 1;
    #endif
    #ifdef MSP_TYPE
    uint64_t m_seed = 1;
    #endif

    inline uint16_t step()
    {
        uint16_t out;
        #ifdef AL_TYPE
        uint16_t t = (m_seed & 0xD000)>>12;
        t |= (m_seed & 0x0008)>>2;
        m_seed <<= 1;
        out = ((m_o>>t)&0x0001);
        m_seed |= out;
        #endif
        #ifdef MSP_TYPE
        out = (m_seed = m_seed * 1103515245 + 12345) % (0xFFFF);
        #endif
        return out;
    }

    command void Synapse_Random.setSeed( uint16_t seed )
    {
        m_seed = seed;
    }

    command uint16_t Synapse_Random.getNextState() // codec, tutti i test
    {
        #ifdef AL_TYPE
        step();
        return m_seed;
        #endif
        #ifdef MSP_TYPE
        return step();
        #endif
    }

}
