/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SYNAPSE_H__
#define __SYNAPSE_H__

#define UQ_SYNAPSE_PARTITION_STORAGE "Synapse_PartitionStorage"

#define SNP_DATA_SIZE   	25
#define TOSH_DATA_LENGTH 	50 //better define this with a -D directive in the Makefile
#define CC2420_DEF_RFPOWER 	27

#define SYMBOLS_PER_BLOCK 	32 
#define SYMBOLS_PER_BLOCK_DIV8  4   	// ceil( SYMBOLS_PER_BLOCK / 8 )
#define CRC_SIZE	2
#define DISSEMINATION_BLOCK_TRESHOLD 1  //must be between 1 and  myAppBlocks
#define SYMBOLS_TO_SEND         36  
#define RECEIVER_SNP_BLOCK_SIZE     50  // >= SYMBOLS_PER_BLOCK

#define START_DEGREE_SEED          0xFA9B 
#define NUM_OF_SEEDS	35

#define GENERIC_DELAY  0x1 					//generic delay  for radio component in term of cycles

#define MIN(a,b) (a)<(b) ? (a) : (b)
#define CEIL(a,b) ((a)%(b)==0) ? ((a)/(b)) : ((a)/(b)+1)

/** ***************************************************************************
*  Internal Use only
*  Don't modify
*****************************************************************************/
#define SWAP_IN_PLACE
#define SYMBOL_SIZE     SNP_DATA_SIZE
#define PACKET_SIZE     SNP_DATA_SIZE
#define PCK_TO_SEND     SYMBOLS_TO_SEND
#define SNP_BLOCK_SIZE  (SYMBOLS_PER_BLOCK * SYMBOL_SIZE)     //in bytes
#define MAX_PCK_ARQ     (RECEIVER_SNP_BLOCK_SIZE-SYMBOLS_PER_BLOCK)
#define MAX_BLOCKS		64
#define MAX_BLOCKS_DIV8 8

#define MAX_CMD 			3
#define MAX_BACKOFF 		16
#define ADV_DELAYED_LIMIT 	3

#endif //__SYNAPSE_H__
