/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "asm_utils.h"

void waitMicro(uint16_t u)
{
    uint16_t i;
    for (i = 0; i < u; i++) {
        __asm volatile ("nop\n\t"
            "nop\n\t"
            "nop\n\t"
            "nop\n\t");
    }
}

/**
 *Initialize Functions
 */
inline void setPinDirection()
{
    /*
	P1OUT = 0x00;
    P2OUT = 0x00;
    P3OUT = 0x00;
    P4OUT = 0x00;
    P5OUT = 0x00;
    P6OUT = 0x00;

    P1SEL = 0x00;
    P2SEL = 0x00;
    P3SEL = 0x00;
    P4SEL = 0x00;
    P5SEL = 0x00;
    P6SEL = 0x00;

    P1DIR = 0x07;

    P4DIR = 0xff;
    P5DIR = 0x0f;
    P6DIR = 0xf0;
	*/
	P3SEL = 0x0E; // set SPI and I2C to mod func

  	P1DIR = 0xe0;
  	P1OUT = 0x00;

  	P2DIR = 0x7b;
  	P2OUT = 0x10;

  	P3DIR = 0xf1;
  	P3OUT = 0x00;

  	P4DIR = 0xfd;
  	P4OUT = 0xdd;

  	P5DIR = 0xff;
  	P5OUT = 0xff;

  	P6DIR = 0xff;
  	P6OUT = 0x00;


    //MAKE_TDA_PWDDD_OUTPUT();
    //MAKE_TDA_ENTDA_OUTPUT();
    MAKE_FLASH_CS_OUTPUT();
    //MAKE_POT_SD_OUTPUT();
    //MAKE_POT_EN_OUTPUT();

    //CLR_TEMP_EN_PIN();
    //MAKE_TEMP_EN_OUTPUT();

    //SEL_USB_POWER_MODFUNC();
    //MAKE_USB_POWER_INPUT();

    waitMicro(1024 * 12);

    //SET_TDA_ENTDA_PIN();
    SET_FLASH_CS_PIN();
    //SET_POT_SD_PIN();
    //SET_POT_EN_PIN();
    //SEL_TEMP_MODFUNC();
    //MAKE_TEMP_INPUT();
    //SEL_LIGHT_MODFUNC();
    //MAKE_LIGHT_INPUT();
    MAKE_SIMO0_OUTPUT();
    MAKE_SOMI0_INPUT();
    MAKE_UCLK0_OUTPUT();

    P1IE = 0;
    P2IE = 0;

    //SET_TDA_PWDDD_PIN();
}
