/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __ASM_UTILS_SYNAPSE_BOOTLOADER__
#define __ASM_UTILS_SYNAPSE_BOOTLOADER__

#include <msp430x16x.h>
//ok
#define SET_FLASH_OUT_PIN()     P3OUT |= (1<<(1))
#define CLR_FLASH_OUT_PIN()     P3OUT &= ~(1<<(1))
//ok
#define SET_FLASH_CLK_PIN()     P3OUT |= (1<<(3))
#define CLR_FLASH_CLK_PIN()     P3OUT &= ~(1<<(3))
//1,7 -> 4,4
#define SET_FLASH_SELECT_PIN()  P4OUT |= (1<<(4))
#define CLR_FLASH_SELECT_PIN()  P4OUT &= ~(1<<(4))

#define SET_FLASH_HOLD_PIN()	P4OUT |= (1<<(7))
#define CLR_FLASH_HOLD_PIN()	P4OUT &= ~(1<<(7))

#define SET_FLASH_PWR_PIN()		P4OUT |= (1<<(3))
#define CLR_FLASH_PWR_PIN()		P4OUT &= ~(1<<(3))

//ok
#define READ_FLASH_IN_PIN()     P3IN & (1<<(2))

//not present... needed? //replace with radio?
#define MAKE_TDA_PWDDD_OUTPUT() P1DIR |= 1 << 0
#define MAKE_TDA_ENTDA_OUTPUT() P1DIR |= 1 << 6

//1,7 -> 4,4
#define MAKE_FLASH_CS_OUTPUT()  P4DIR |= 1 << 4
#define MAKE_FLASH_HOLD_OUTPUT() P4DIR |= 1 << 7
#define MAKE_FLASH_PWR_OUTPUT() P4DIR |= 1 << 3

//not present... needed?
#define MAKE_POT_SD_OUTPUT()    P2DIR |= 1 << 3
#define MAKE_POT_EN_OUTPUT()    P2DIR |= 1 << 4

//not present... needed?
#define CLR_TEMP_EN_PIN()       P5OUT &= ~(1 << 4)
#define MAKE_TEMP_EN_OUTPUT()   P5DIR |= 1 << 4

//not present... needed?
#define SEL_USB_POWER_MODFUNC() P1SEL |= 1 << 3
#define MAKE_USB_POWER_INPUT()  P1DIR &= ~(1 << 3)

//not present... needed?
#define SET_TDA_ENTDA_PIN()     P1OUT |= 1 << 6

//1,7 -> 4,4
#define SET_FLASH_CS_PIN()      P4OUT |= 1 << 4
#define CLR_FLASH_CS_PIN()      P4OUT &= ~(1<<(4))

//not present... needed?
#define SET_POT_SD_PIN()        P2OUT |= 1 << 3
#define SET_POT_EN_PIN()        P2OUT |= 1 << 4
#define SEL_TEMP_MODFUNC()      P6SEL |= 1 << 0
#define MAKE_TEMP_INPUT()       P6DIR &= ~(1 << 0)
#define SEL_LIGHT_MODFUNC()     P6SEL |= 1 << 2
#define MAKE_LIGHT_INPUT()      P6DIR &= ~(1 << 2)
#define SET_TDA_PWDDD_PIN()     P1OUT |= 1 << 0

//1,7 -> 4,4
#define SEL_FLASH_CS_IOFUNC()   P4SEL &= ~(1 << 4)

//OK
#define SEL_UTXD0_IOFUNC()      P3SEL &= ~(1 << 4)
#define SEL_URXD0_IOFUNC()      P3SEL &= ~(1 << 5)
#define SEL_SIMO0_MODFUNC()     P3SEL |= 1 << 1
#define SEL_SOMI0_MODFUNC()     P3SEL |= 1 << 2
#define SEL_UCLK0_MODFUNC()     P3SEL |= 1 << 3
#define MAKE_SIMO0_OUTPUT()     P3DIR |= 1 << 1
#define MAKE_SOMI0_INPUT()      P3DIR &= ~(1 << 2)
#define MAKE_UCLK0_OUTPUT()     P3DIR |= 1 << 3

/* Enable/Disable interrupts */
#define eint()  __asm__ __volatile__("eint"::)
#define dint()  __asm__ __volatile__("dint"::)


/**
 *General Use Functions
 */
void waitMicro(uint16_t u);

/**
 *Initialize Functions
 */
inline void setPinDirection();

#endif //__ASM_UTILS_SYNAPSE_BOOTLOADER__
