/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SYNAPSE_BOOTLOADER_H__
#define __SYNAPSE_BOOTLOADER_H__

#define IF_OPCODE_ADDR          0x1000
#define IF_IMG2LOAD_ADDR        0x1002  
#define IF_ID_ADDR              0x1002  
#define IF_SIZE_ADDR            0x1004  
#define IF_SN_ADDR              0x1006  
#define IF_NODE_ID_ADDR         0x1008	// node ID
#define IF_PROTECTED_FLAG				0x100A	// address protected flag

/*
 * PRESERVE_GOLDEN_IMAGE defined rewrite the current app in
 * partition 1 after every flash format, and load it after
 * each reboot from another application or after an error in
 * the bootloader
 */
#define PRESERVE_GOLDEN_IMAGE

sfrw(opcode, IF_OPCODE_ADDR);
sfrw(imgToLoad, IF_IMG2LOAD_ADDR);
sfrw(appID, IF_ID_ADDR);
sfrw(imgSize, IF_SIZE_ADDR);
sfrw(if_sn, IF_SN_ADDR);
sfrw(ifNodeId, IF_NODE_ID_ADDR);
sfrw(ifNotProtected, IF_PROTECTED_FLAG);

enum SynapseBootloaderCommands_enum {
    SBC_NONE            = 0,
    SBC_FORMAT          = 1,
    SBC_STORE           = 2,
    SBC_LOAD_ID         = 3,
    SBC_LOAD_PARTITION  = 4,
    SBC_INTERNAL_FORMAT = 15,
    SBC_ONLY_FORMAT     = 16,
    SBC_FORMAT_SPECIAL	= 17  			//format and store golden image
};


#define PROG_FLASH_SIZE				0xAFFF		//IF_SIZE-0x5000 

#define GOLDEN_IMAGE_SIZE			40000u 		//40000 good margin
#warning The bootloader assumes that the Golden Image will be at most 40000 bytes
#define GOLDEN_IMAGE_ID				0x36B9

void reboot() {
  //Enable watchdog
  WDTCTL = WDT_ARST_1_9;
  while(1);
}

#endif // __SYNAPSE_BOOTLOADER_H__
