/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SYNAPSE_BOOTLOADER_EXTERNAL_FLASH__
#define __SYNAPSE_BOOTLOADER_EXTERNAL_FLASH__

#include "asm_utils.h"
#include "volumes-stm25p.h"

#define UQ_EF_RESOURCE "uq_stm25p.resouce"

#define EF_NUM_PAGES            2048
#define EF_PAGE_SIZE            256 
#define EF_PAGE_SIZE_LOG2		8
#define EF_SECTOR_SIZE			0x10000

/* External Flash OPCODES */
#define WREN				0x6
#define WRDI				0x4
#define RDSR				0x5
#define WRSR				0x1
#define READ				0x3
#define FAST_READ			0xB
#define PP					0x2
#define SE					0xD8
#define BE					0xC7
#define	DP					0xB9
#define RES					0xAB

#define EF_VOLUME_BASE ((STM25P_VMAP[VOLUME_SYNAPSE].base)*EF_SECTOR_SIZE)
#define EF_VOLUME_SIZE ((STM25P_VMAP[VOLUME_SYNAPSE].size)*EF_SECTOR_SIZE)

inline void initializeExternalFlash();


/**
 *  SPI R/W
 */
uint8_t externalFlash_startCommandRW(uint8_t *cmdBuf, uint16_t n);
void externalFlash_commandR(uint8_t *rxBuf, uint16_t n);
void externalFlash_commandW(uint8_t *txBuf, uint16_t n);
inline void externalFlash_endCommand();

/**
 *  External Flash R/W
 */


void externalFlash_Read(uint32_t offset, uint8_t *data, uint16_t n);
void externalFlash_Write(uint32_t offset, uint8_t *data, uint16_t n);
void externalFlash_Erase();
void externalFlash_write_disable();
void externalFlash_write_enable();
int isTxEmpty();
int isTxIntrPending();
int isRxIntrPending();
void externalFlash_WakeUp();
#ifdef DEBUG_SYNAPSE_BOOTLOADER
void externalFlash_BlinkSR();
void externalFlash_BlinkABit();
#endif
void externalFlash_clearSR();
void externalFlash_waitForWip();


#endif // __SYNAPSE_BOOTLOADER_EXTERNAL_FLASH__
