/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "internal_flash.h"
#include "asm_utils.h"

#ifdef BOOTLOADER
void internalFlash_erase(uint8_t *startAddr, uint16_t size)
{
    uint16_t i;
    for(i=0; i<size; i+=IF_MIN_MEM_ERASE_SIZE) {
        FCTL2 = FWKEY + FSSEL1 + FN2;
        FCTL3 = FWKEY;
        FCTL1 = FWKEY + ERASE; //segment erase
        startAddr[i] = 0;
        FCTL1 = FWKEY;
        FCTL3 = FWKEY + LOCK;
    }
    FCTL2 = FWKEY + FSSEL1 + FN2;
    FCTL3 = FWKEY;
    FCTL1 = FWKEY + ERASE; //segment erase
    startAddr[size-1] = 0;
    FCTL1 = FWKEY;
    FCTL3 = FWKEY + LOCK;
}

void internalFlash_write8(volatile uint8_t *addr, uint8_t val)
{
    FCTL2 = FWKEY + FSSEL1 + FN2;
    FCTL3 = FWKEY;
    FCTL1 = FWKEY + WRT;
    *addr = val;
    FCTL1 = FWKEY;
    FCTL3 = FWKEY + LOCK;
}

void internalFlash_write16(volatile uint16_t *addr, uint16_t val)
{
    FCTL2 = FWKEY + FSSEL1 + FN2;
    FCTL3 = FWKEY;
    FCTL1 = FWKEY + WRT;
    *addr = val;
    FCTL1 = FWKEY;
    FCTL3 = FWKEY + LOCK;
}
#endif

void internalFlash_writeSegment(uint8_t inf, uint8_t offset, uint16_t *data, uint8_t len)
{
    uint16_t infData[IF_MIN_INF_ERASE_SIZE16];
    uint8_t i;
    volatile uint16_t *p;
    if(offset>0x80) {
        return;
    }
    if(inf == 0) {  //segment A
        p = (uint16_t *)IF_SEGMENT_A_ADDR;
    } else {    //segment B
        p = (uint16_t *)IF_SEGMENT_B_ADDR;
    }
    if(offset+len>IF_MIN_INF_ERASE_SIZE16) {
        len = IF_MIN_INF_ERASE_SIZE16-offset;
    }
    // save data
    for(i=0; i<IF_MIN_INF_ERASE_SIZE16; i++) {
        infData[i] = p[i];
    }
    // update data
    for(i=0; i<len; i++) {
        infData[offset+i] = data[i];
    }
    // clear segment
    dint();
    FCTL2 = FWKEY + FSSEL1 + FN2;
    FCTL3 = FWKEY;
    FCTL1 = FWKEY + ERASE;
    p[0] = 0;
    FCTL1 = FWKEY;
    FCTL3 = FWKEY + LOCK;
    // store data
    for(i=0; i<IF_MIN_INF_ERASE_SIZE16; i++) {
        FCTL2 = FWKEY + FSSEL1 + FN2;
        FCTL3 = FWKEY;
        FCTL1 = FWKEY + WRT;
        p[i] = infData[i];
        FCTL1 = FWKEY;
        FCTL3 = FWKEY + LOCK;
    }
    eint();
}
