/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SYNAPSE_BOOTLOADER_INTERNAL_FLASH__
#define __SYNAPSE_BOOTLOADER_INTERNAL_FLASH__

#include <msp430x16x.h>

#define IF_MIN_MEM_ERASE_SIZE   512     // 0x200
#define IF_MIN_INF_ERASE_SIZE   128     // 0x80
#define IF_MIN_INF_ERASE_SIZE16 0x40    // 64
#define IF_SEGMENT_A_ADDR       0x1000
#define IF_SEGMENT_B_ADDR       0x1080
#define IF_SEGMENT_A            0
#define IF_SEGMENT_B            1
#define INTERRUPT_TABLE_SIZE    0x20    // 32
#define INTERRUPT_TABLE_ADDR    0xFFE0


/**
 *  Internal Flash R/W
 */

void internalFlash_erase(uint8_t *startAddr, uint16_t size);

void internalFlash_write8(volatile uint8_t *addr, uint8_t val);

void internalFlash_write16(volatile uint16_t *addr, uint16_t val);

void internalFlash_writeSegment(uint8_t inf, uint8_t offset, uint16_t *data, uint8_t len);

#endif // __SYNAPSE_BOOTLOADER_INTERNAL_FLASH__
