/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "leds.h"
#include "asm_utils.h"

void int2leds4(uint16_t n)
{
    uint16_t i;
    P5OUT &= 0xF0;
    P5OUT |= (n & 0x000F);
    for(i=0; i<1000; i++) {
        waitMicro(1000);
    }
}

void int2leds8(uint8_t n)
{
	uint8_t i;
	for(i=0; i<8 ; i++){ //SR - 1st reading
	flash((n>>i & 1)+1);
	flash((n>>i & 1)+1);
	flash(0);
	flash(0);
    }
}
void int2leds16(uint16_t n)
{
	int2leds8((uint8_t)(n & 0xFF));
	flash(7);
	flash(7);
	int2leds8((uint8_t)(n>>8 & 0xFF));
}
void int2leds32(uint32_t n)
{
    int2leds16(n&0xFFFF);
    int2leds16((n>>16)&0xFFFF);
}

void blink(uint8_t l)
{
    uint8_t i;
    P5OUT |= 0xF1;
    for(i=0; i<5; i++) {
        uint16_t j, k;
        P5OUT ^= l<<4;
        for(k=0x05; k>0; k--)
            for(j=0xFFFF; j>0; j--);
    }
	P5OUT |= 0xF1;
}

void flash(uint8_t l)
{
	l &=0x0F;
    P5OUT |= 0xF1;
    P5OUT ^= l<<4;
    uint16_t j, k;
        for(k=0x05; k>0; k--)
            for(j=0xFFFF; j>0; j--);
	P5OUT |= 0xF1;
}

void blink13() //101
{
	blink(5);
}
void blink12() //110
{
blink(3);
}
void blink123() //111
{
	blink(7);
}
