/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef FLASH_MANAGER_MESSAGES_H
#define FLASH_MANAGER_MESSAGES_H

#ifndef TOSH_DATA_LENGTH
#define TOSH_DATA_LENGTH 50
#endif

#define DATASIZE (TOSH_DATA_LENGTH-10)

enum{
		AM_SERIAL_SYNAPSE_OFFSET	= 140,		
		AM_FLASHMANAGERCMD			= AM_SERIAL_SYNAPSE_OFFSET,
		AM_FLASHMANAGERDATA			= AM_SERIAL_SYNAPSE_OFFSET + 1,
};

enum{
		CMD_NOOP			= 0,
		CMD_READTABLE		= 1,
		CMD_READAPP			= 2,
		CMD_ADDENTRY		= 3,
		CMD_FORMAT			= 4,
		CMD_ENTRYREADY		= 5,
		CMD_ACK				= 9,
};

enum{
		NOTHING				= 0,
		TABLE_ENTRY			= 1,
		DATA_CHUNK			= 2,
};

typedef nx_struct FlashManagerCmd{
	nx_uint8_t cmd;
	nx_uint8_t param8_1;
	nx_uint8_t param8_2;
	nx_uint16_t param16_1;
	nx_uint16_t param16_2;
}FlashManagerCmd;

typedef nx_struct FlashManagerData{
	nx_uint8_t type;
	nx_uint32_t address;
	nx_uint32_t size;
	//partition ID?
	nx_uint8_t data[DATASIZE];	
}FlashManagerData;

#endif /* FLASH_MANAGER_MESSAGES_H */
