/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "FlashManagerMessages.h"
#include "StorageVolumes.h"

/**
 * @author Moreno Dissegna
 */
configuration SerialFlashManagerC{
	provides interface Init;
	uses interface Boot;
}
implementation{
	
	components SerialFlashManagerP;
	
	Boot = SerialFlashManagerP.Boot;
	Init = SerialFlashManagerP.Init;
	
	//components MainC;
	//SerialFlashManagerP -> MainC.Boot;
	//MainC.SoftwareInit -> SerialFlashManagerP.Init;

	components LedsC;
	SerialFlashManagerP.Leds -> LedsC;

	components new Synapse_PartitionStorageC() as PartitionManager;
	SerialFlashManagerP.BlockRead ->PartitionManager.BlockRead;
	SerialFlashManagerP.BlockWrite->PartitionManager.BlockWrite;
	SerialFlashManagerP.Synapse_PartitionStorage -> PartitionManager.Synapse_PartitionStorage;
	
	components SerialActiveMessageC as SerialAM;
	SerialFlashManagerP.SerialSplitControl 	-> SerialAM.SplitControl;
	SerialFlashManagerP.SerialPacket       	-> SerialAM.Packet;
	SerialFlashManagerP.CommandSend		-> SerialAM.AMSend [AM_FLASHMANAGERCMD];
	SerialFlashManagerP.CommandReceive	-> SerialAM.Receive [AM_FLASHMANAGERCMD];
	SerialFlashManagerP.DataSend		-> SerialAM.AMSend [AM_FLASHMANAGERDATA];
	SerialFlashManagerP.DataReceive		-> SerialAM.Receive [AM_FLASHMANAGERDATA];
	
	components Synapse_BootloaderCommunicationC as Bootloader;
	SerialFlashManagerP.Synapse_BootloaderCommunication -> Bootloader;
			
}