/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#include "bootloader.h"
#include "internal_flash.c"

module Synapse_BootloaderCommunicationP
{
	provides {
		interface Synapse_BootloaderCommunication;
	}
}

implementation
{
	uint16_t t[5];
	uint16_t i;

	command error_t Synapse_BootloaderCommunication.reboot()
	{
		reboot();
		return SUCCESS;
	}

	command error_t Synapse_BootloaderCommunication.formatFlash()
	{
		#ifdef PRESERVE_GOLDEN_IMAGE
		t[0] = SBC_FORMAT_SPECIAL;  		// format and store golden image
		#else
		t[0] = SBC_FORMAT;					//format and remain idle
		#endif
		t[1] = 0;   						// uint16_t id_partition;
		t[2] = 0;   						// uint16_t size;
		t[3] = if_sn;
		atomic {
			internalFlash_writeSegment(IF_SEGMENT_A, 0, t, 4);
			for(i=0;i<0xff;i++);  			//wait some time
			reboot();
		}
		return SUCCESS;
	}

	command error_t Synapse_BootloaderCommunication.store(){
		return SUCCESS;
	}

	command error_t Synapse_BootloaderCommunication.loadApplicationID( uint16_t id )
	{
		t[0] = SBC_LOAD_ID;  				// uint16_t cmd;
		t[1] = id;   						// uint16_t id_partition;
		t[2] = 0;   						// uint16_t size;
		atomic {
			internalFlash_writeSegment(IF_SEGMENT_A, 0, t, 3);
			for(i=0;i<0xff;i++);
			reboot();
		}
		return SUCCESS;
	}

	command error_t Synapse_BootloaderCommunication.loadApplicationPartition( uint16_t pos )
	{
		t[0] = SBC_LOAD_PARTITION;  		// uint16_t cmd;
		t[1] = pos;   						// uint16_t partition_id;
		t[2] = 0;   						// uint16_t size;
		atomic {
			internalFlash_writeSegment(IF_SEGMENT_A, 0, t, 3);
			reboot();
		}
		return SUCCESS;
	}
	
	command error_t Synapse_BootloaderCommunication.writeSN( uint16_t sn )
	{
		t[0] = sn;
		atomic {
			internalFlash_writeSegment(IF_SEGMENT_A, 3, t, 1);
		}
		return SUCCESS;
	}

	command uint16_t Synapse_BootloaderCommunication.readNodeId(){
		return ifNodeId;
	}

//TODO: verify write protect bit
	command error_t Synapse_BootloaderCommunication.writeNodeId( uint16_t node_id ){
		if(!ifNotProtected) return EALREADY;
		t[0] = node_id;
		t[1] = 0;
		atomic {
			internalFlash_writeSegment(IF_SEGMENT_A, 4, t, 2);  //write address and protect it
		}
		return SUCCESS;
	}
}
