/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SYNAPSE_PARTITION_H_
#define SYNAPSE_PARTITION_H_


typedef struct SynapsePartitionEntry_struct {
    uint16_t flags;
    uint16_t hashName;
    uint32_t startAddr; 			// first byte written
    uint32_t size;      			// partition size
    uint16_t progStartOffs;
} SynapsePartitionEntry;

// Flags
#define SPE_USED        (1<<0)
#define SPE_PROG        (1<<1)
#define SPE_NV_MEM      (1<<2) // non volatile?
#define SPE_WORKING     (1<<3)

#define S_PARTITION_ENTRY_SIZE      14      	// sizeof(SynapsePartitionEntry_struct)
#define MAX_PARTITION_ENTRY         18      	// EF_SIZE_PAGE/S_PARTITION_ENTRY_SIZE
#define EF_PARTITION_TABLE_ADDR     0x00

uint8_t partitionUsed(SynapsePartitionEntry *pe){
	return (~(pe->flags) & SPE_USED);
}

#endif /* SYNAPSE_PARTITION_H_ */
