/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#include "Storage_chip.h"
#include "StorageVolumes.h"
#include <Storage.h>
#include "bootloader.h"
#include "external_flash.h"
#include "Synapse.h"


generic configuration Synapse_PartitionStorageC()
{
    provides {
		interface Synapse_PartitionStorage;
		interface BlockRead;
		interface BlockWrite;
//		command SynapsePartitionEntry* get_PartitionEntry(uint16_t part_num);
		command uint16_t get_NumOfImg();
    }
}

implementation {
    enum {
		SYNAPSE_PARTITION_ID = (VOLUME_SYNAPSE),
		SYNAPSE_PARTITION_CLIENT_ID = unique(UQ_SYNAPSE_PARTITION_STORAGE),
		RESOURCE_ID = unique(UQ_EF_RESOURCE)
    };

//	components Synapse_PartitionStorageP;
//	Synapse_PartitionStorage = Synapse_PartitionStorageP.Synapse_PartitionStorage[SYNAPSE_PARTITION_CLIENT_ID];
//	get_PartitionEntry = Synapse_PartitionStorageP.get_PartitionEntry;
//	get_NumOfImg = Synapse_PartitionStorageP.get_NumOfImg;
//	components new BlockStorageC(SYNAPSE_PARTITION_ID);
//	Synapse_PartitionStorageP.FlashRead -> BlockStorageC;
//	Synapse_PartitionStorageP.FlashWrite -> BlockStorageC;
	
	components Synapse_PartitionStorageCP;
	Synapse_PartitionStorage = Synapse_PartitionStorageCP.Synapse_PartitionStorage[SYNAPSE_PARTITION_CLIENT_ID];
	get_NumOfImg = Synapse_PartitionStorageCP.get_NumOfImg;
	
	BlockRead  = Synapse_PartitionStorageCP.BlockRead[SYNAPSE_PARTITION_CLIENT_ID];
	BlockWrite = Synapse_PartitionStorageCP.BlockWrite[SYNAPSE_PARTITION_CLIENT_ID];

	components MainC;
	Synapse_PartitionStorageCP.Boot -> MainC.Boot;
		
}
