/*
 * Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
 * Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * The name of the author may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SYNAPSENP_MSGS_H__
#define __SYNAPSENP_MSGS_H__

#include <AM.h>
#include "Synapse.h"

#define AM_SYNAPSE_CMD_OFFSET 120
enum {
    AM_SYNAPSE_CMD         = AM_SYNAPSE_CMD_OFFSET+0,
    AM_SYNAPSE_DATA        = AM_SYNAPSE_CMD_OFFSET+1,
    AM_SYNAPSE_BLOCK_INFO  = AM_SYNAPSE_CMD_OFFSET+2,
    AM_SYNAPSE_ARQ         = AM_SYNAPSE_CMD_OFFSET+3,
    AM_SYNAPSE_FEEDBACK    = AM_SYNAPSE_CMD_OFFSET+4,
    AM_SYNAPSE_DEBUG       = AM_SYNAPSE_CMD_OFFSET+5,
    AM_SYNAPSE_DEBUG_TIME  = AM_SYNAPSE_CMD_OFFSET+6,
    AM_SYNAPSE_START  		= AM_SYNAPSE_CMD_OFFSET+7, //127
    AM_SYNAPSE_SERIALCOMMAND = 127,
    AM_SYNAPSE_ADV			= AM_SYNAPSE_CMD_OFFSET+8,
    AM_SYNAPSE_REQ			= AM_SYNAPSE_CMD_OFFSET+9,
    AM_SYNAPSE_PING		= AM_SYNAPSE_CMD_OFFSET+10,
    AM_SYNAPSE_SERIAL_PING = AM_SYNAPSE_CMD_OFFSET+11,
    DEBUG_TYPE  =	87,
};

enum Synapse_Commands {
    NoneCmd         = 0,
    Format          = 1,    // Format ext flash and internal flash
    Store           = 2,    // init to receive a new prog
    LoadID          = 3,    // load from ext flash a prog with hash_name==ID
    LoadPartition   = 4,    // load from ext flash the prog stored in partition==PARTITION
    Send            = 5,    // send a prog in ext flash
    Reboot          = 14,
    InternalFormat  = 15,   // Format ext flash and restat current application
    NumOfCmd        = 16
};

enum Synapse_AdvCommands {
	transferCmd 	=	1,
	netFormatCmd 	=	2,
	netResetCmd		=	3,
	netLoadCmd		=	4,
	advProcedure 	=	5,
	prepareCmd		=	6,
	pingReqMsg 		=   7,
	pingRepMsg		=	8,
	tagCmd			=   9,
	invalidCmd		=	128,
};

typedef nx_struct Synapse_serialCommand {
        nx_uint8_t cmd;
        nx_uint16_t arg;
} Synapse_serialCommand;

typedef nx_struct Synapse_Ping{
		nx_uint16_t dest;
		nx_uint8_t partNum;
		nx_uint8_t pingFlags;
		nx_uint8_t status;
		nx_uint32_t imgSize;
		nx_uint32_t imgOffset;
		nx_uint16_t imgId;
		nx_uint16_t imgFlags;
} Synapse_Ping;

#define PING_REPLY_FLAG (1)
#define PING_PREPARED_FLAG (1<<1)
#define PING_OVERFLOW_FLAG (1<<2)

typedef nx_struct Synapse_Adv_Msg {
	nx_uint16_t appId;
	nx_uint16_t size;
	nx_uint16_t progStartOffs;
	nx_uint8_t blocks[MAX_BLOCKS_DIV8];		//#bit mask of available blocks
	nx_uint8_t hopCount;
	nx_uint8_t slot;			//time to end ADV slot
	#ifdef STAT
	nx_uint16_t cycles;		//to keep trace previous hops
	#endif
}Synapse_Adv_Msg;

typedef nx_struct Synapse_Cmd_Msg {
	nx_uint8_t cmd;
	nx_uint16_t appId;
}Synapse_Cmd_Msg;

typedef nx_struct Synapse_Req_Msg {
	nx_am_addr_t s_addr;
	nx_uint8_t blocks;
}Synapse_Req_Msg;

/** Data msg */
typedef nx_struct Synapse_Data_Msg {
    nx_uint16_t blockId;
    nx_uint16_t seed;
    nx_uint8_t data[SNP_DATA_SIZE];
} Synapse_Data_Msg;

/** Data Decode msg */
typedef nx_struct Synapse_Data_Decode_Msg {
    nx_uint8_t type;
} Synapse_Data_Decode_Msg;

/** ARQ msg */
enum Synapse_ARQ_Types {
    ARQ_REQ     = 0,    // From receiver
    ARQ_DECODE  = 1,    // From sender to start contentiopn
};
typedef nx_struct Synapse_ARQ_Msg {
    nx_uint16_t blockId;
    nx_uint16_t number;
    nx_uint8_t type;
} Synapse_ARQ_Msg;

/** FeedBack msg */
enum Synapse_FeedBack_Types {
    FEEDBACK_TYPE_REQ       = 0,    // nella fase iniziale serve per ciedere chi vuol essere eletto
    FEEDBACK_TYPE_RESP      = 1,    // mi offro come feedbacker
    FEEDBACK_TYPE_CONFIRM   = 2,    // confermo il feedbacker
    FEEDBACK_TYPE_SYNC_REQ  = 3,
    FEEDBACK_TYPE_SYNC_RESP = 4,
    FEEDBACK_TYPE_SYNC_NAK  = 5,
};
typedef nx_struct Synapse_FeedBack_Msg {
    nx_uint8_t type;
    nx_am_addr_t feedbackerAddr;
} Synapse_FeedBack_Msg;

/** Debug msg */
typedef nx_struct Synapse_Debug_Msg {
    nx_uint16_t p1;
    nx_uint16_t o1;
    nx_uint16_t l1;
    nx_uint16_t p2;
    nx_uint16_t o2;
    nx_uint16_t l2;
} Synapse_Debug_Msg;

/** Debug Time msg */
typedef nx_struct Synapse_Debug_Time_Msg {
    nx_uint32_t cod;
    nx_uint32_t dec;
    nx_uint16_t it;
    nx_uint8_t d;
    nx_uint8_t b;
} Synapse_Debug_Time_Msg;

/** Debug Param msg */
enum{
    TYPE_DEBUG_APP_TX   =	0xA1, // p32_1=programmingTimeNF, p32_2=programmingTimeF
    TYPE_DEBUG_APP_RX   =	0xA2, // p32_1=programmingTimeNF, p32_2=programmingTimeF
    TYPE_DEBUG_BLOCK_TX =	0xB1, // p32_1=blockTxTime, p16_1=txPcks p8_1=nRound
    TYPE_DEBUG_BLOCK_RX =	0xB2, // p32_1=blockRxTime, p16_1=rxPcks p8_1=nRound
    TYPE_DEBUG_ROUND_RX =	0xE2,  // p32_1=roundRxTime, p16_1=rxPcks p8_1=nRound
    TYPE_DEBUG_ROUND_TX =	0xE1,
    TYPE_SNP_STAT	=	0x21,
    TYPE_SNP_SKEW	=	0x22,
    TYPE_SNP_FIRST	=	0x23, //first adv received
    TYPE_SNP_END	=	0x24,
};
typedef nx_struct Synapse_Debug_Param_Msg { // size 16
    nx_uint8_t  type;
    nx_uint32_t p32_1;
    nx_uint32_t p32_2;
    nx_uint16_t p16_1;
    nx_uint16_t p16_2;
    nx_uint8_t  p8_1;
    nx_uint8_t  p8_2;
} Synapse_Debug_Param_Msg;


/** ***************************************************************************
*  Timing definitions for SyNapSe
*****************************************************************************/

enum{
	TIMER_FREQ = 1,						//timer ticks per millisecond
	TX_RATE_MS = 31,						//bytes per millisecond
	MINIMUM_SKEW = 3*TIMER_FREQ,
	SLOT_NUM_LOG2 = 5,					//4 means 16 slots, 5 means 32 
	SLOT_NUM = (1<<SLOT_NUM_LOG2),
	TOTAL_DATA_TRANSMISSION_TIME = (600*TIMER_FREQ),
	MAX_DECODE_TIME = (500*TIMER_FREQ),
	GUARD_INTERVAL = 10*TIMER_FREQ,
};

#define	ADV_TX_TIME_uS		(1024*sizeof(Synapse_Adv_Msg)+sizeof(message_header_t)*sizeof(uint8_t))/(TX_RATE_MS)
#define	REQ_TX_TIME_uS		(1024*sizeof(Synapse_Req_Msg)+sizeof(message_header_t)*sizeof(uint8_t))/(TX_RATE_MS)
#define	DATA_TX_TIME_uS	    (1024*sizeof(Synapse_Data_Msg)+sizeof(message_header_t)*sizeof(uint8_t))/(TX_RATE_MS)

#endif //__SYNAPSENP_MSGS_H__
