#!/usr/bin/python
import os
import socket
import math
import sys
import time
import sys
import string
import tinyos
import tinyosSF

AM_FLASHMAN_CMD 	= 140
AM_FLASHMAN_DATA 	= 141

SPE_USED			= (1)
SPE_WORKING			= (1<<3)

CMD_NOOP			= 0
CMD_READTABLE		= 1
CMD_READAPP			= 2
CMD_ADDENTRY		= 3
CMD_FORMAT			= 4
CMD_ENTRYREADY      = 5
CMD_ACK 			= 9

TYPE_NOTHING		= 0
TYPE_TABLE_ENTRY	= 1
TYPE_DATA_CHUNK		= 2


serialPort = "/dev/ttyUSB0"
platform = "telosb"
port = 0
cmdFound=0

#typedef nx_struct FlashManagerData{
#	nx_uint8_t type;
#	nx_uint32_t address;
#	nx_uint32_t size;
#	//partition ID?
#	nx_uint8_t data[TOSH_DATA_LENGTH-9];	
#}FlashManagerData;

class CommandPacket(tinyos.GenericPacket):
	def __init__(self, packet = None):
		tinyos.GenericPacket.__init__(self,
		[('cmd','int',  1),
		('param8_1', 'int',  1),
		('param8_2', 'int',  1),
		('param16_1', 'int',  2),
		('param16_2', 'int',  2),],
		packet)
	
class AckPacket(tinyos.GenericPacket):
	def __init__(self, packet = None):
		tinyos.GenericPacket.__init__(self,
		[('cmd','int',  1),
		('end', 'int',  1),
		('param8_2', 'int',  1),
		('param16_1', 'int',  2),
		('param16_2', 'int',  2),],
		packet)
	
class EntryReadyPacket(tinyos.GenericPacket):
	def __init__(self, packet = None):
		tinyos.GenericPacket.__init__(self,
		[('cmd','int',  1),
		('pos', 'int',  1),
		('error', 'int',  1),
		('id', 'int',  2),
		('size', 'int',  2),],
		packet)	
		
class TablePacket(tinyos.GenericPacket):
	def __init__(self, packet = None):
		tinyos.GenericPacket.__init__(self,
		[('type','int',1),
		('end',  'int',  4),
		('size',  'int',  4),
		('data1',  'int',  14),
		('data2',  'int',  14),],
		packet)

class ChunkPacket(tinyos.GenericPacket):
	def __init__(self, packet = None):
		tinyos.GenericPacket.__init__(self,
		[('type','int',1),
		('end',  'int',  4),
		('size',  'int',  4),
		('data',  'int',  40),],
		packet)

class DataPacket(tinyos.GenericPacket):
	def __init__(self, packet = None):
		tinyos.GenericPacket.__init__(self,
		[('type','int',1),
		('address',  'int',  4),
		('size',  'int',  4),
		('data',  '[]',  40),],
		packet)


def sendCmd(cmd,p1,p2,p3,p4,port=0):
	if (port==0):
		comm=tinyos.Serial(serialPort, platform)
	else:
		comm=tinyosSF.Forwarder(port)
	sCmdPacket = CommandPacket((cmd,p1,p2,p3,p4))
	comm.write_packet(0, AM_FLASHMAN_CMD , sCmdPacket.payload())

		
def read(port=0):
	if (port!=0):
		comm=tinyosSF.Forwarder(port)
	else:
		comm=tinyos.Serial(serialPort, platform)
	while True:
		packet=comm.read_packet(0,AM_FLASHMAN_DATA)
		replyPkt=TablePacket(packet[1])	
		print "%028X " %replyPkt.data1
		print "%028X " %replyPkt.data2 
		if replyPkt.end == 1:
			print "END"
			break

		
def readApp(port=0):
	if (port!=0):
		comm=tinyosSF.Forwarder(port)
	else:
		comm=tinyos.Serial(serialPort, platform)

	while True:
		packet=comm.read_packet(0,AM_FLASHMAN_DATA)
		replyPkt=ChunkPacket(packet[1])
		txtdata = "%080X" %replyPkt.data
		if (replyPkt.size == 40):
			print txtdata[0:40]
			print txtdata[40:80]
		elif (replyPkt.size < 20):
			print txtdata[0:(replyPkt.size*2)]
		elif (replyPkt.size < 40):
			print txtdata[0:40]
			print txtdata[40:((replyPkt.size)*2)]
		if replyPkt.end == 1:
			print "END"
			break

def writeApp(appID,filename,port=0):
	if (port!=0):
		comm=tinyosSF.Forwarder(port)
	else:
		comm=tinyos.Serial(serialPort, platform)
		
	segmentdata = []
	data = [40]
	file = open(filename,"rb")
	lines = file.readlines()
	for l in lines:
		if (l[0] != ':'): 
			sys.stderr.write("Ignored unknown field (type 0x%02x) in ihex file.\n" % type)
		l = l.strip()       #fix CR-LF issues...
		length  = int(l[1:3],16)
		address = int(l[3:7],16)
		type    = int(l[7:9],16)
		check   = int(l[-2:],16)
		if type == 0x00:
			for i in range(length):
				segmentdata.append( (int(l[9+2*i:11+2*i],16)) )
		elif type in (0x01, 0x02, 0x03, 0x04, 0x05):
			pass		
		else:
			sys.stderr.write("Ignored unknown field (type 0x%02x) in ihex file.\n" % type)

	appSize = len(segmentdata)
	sCmdPacket = CommandPacket((CMD_ADDENTRY,0,0,appID,appSize))
	comm.write_packet(0, AM_FLASHMAN_CMD , sCmdPacket.payload())
	packet=comm.read_packet(0,AM_FLASHMAN_CMD)
	replyPkt=EntryReadyPacket(packet[1])
	if (replyPkt.error!=0):
		print "error"
	else:
		print "done"
		type = TYPE_DATA_CHUNK
		address = 0
		size = 40
		keepGoing = True
		for i in range(0,appSize,40):
			if (address + size >= appSize ):
				size = appSize-address
			data = segmentdata[address:address+40]
			sDataPacket = DataPacket((type,address,size,data))
			comm.write_packet(0, AM_FLASHMAN_DATA , sDataPacket.payload())
			address = address + size
			packet=comm.read_packet(0,AM_FLASHMAN_CMD)
	
def printUsage():
	print "Usage: ReadValues command [options]"
	print "Commands are:"
	print "\tget_table"
	print "\tread_application <appID>"
	print "\twrite_application <appID>"
	print "\tformat"
	print "Possible options are:"
	print "\t-c comPort"
	print "\t-p platform"
	print "\t--port tcpPort"

for j in range(len(sys.argv)):
	if (sys.argv[j]=='-c'):
		serialPort=sys.argv[j+1]
	if (sys.argv[j]=='-p'):
		platform=sys.argv[j+1]
	if (sys.argv[j]=='--port'):
		port=int(sys.argv[j+1])
	if (sys.argv[j]=='--help'):
		printUsage()
for j in range(len(sys.argv)):
	if (sys.argv[j]=='get_table'):
		cmdFound=1
		sendCmd(CMD_READTABLE,0,0,0,0,port)
		read()
	if (sys.argv[j]=='format'):
		cmdFound=1
		sendCmd(CMD_FORMAT,0,0,0,0,port)
	if (sys.argv[j]=='read_application'):
		cmdFound=1
		sendCmd(CMD_READAPP,0,0,int(sys.argv[j+1],16),0,port)
		readApp()
		j = j + 1
	if (sys.argv[j]=='write_application'):
		cmdFound=1
		writeApp(int(sys.argv[j+1],16),sys.argv[j+2])
		j = j + 2
if(cmdFound==0):
	printUsage()
