#!/bin/bash

#This simple script Creates if necessary the xml file with
#the information required to install the application using the
#Synapse bootloader. 

#Copyright (c) 2008 Department of Information Engineering, University of Padova, Italy
#Contributors: Giovanni Zanca, Nicola Bui, Riccardo Crepaldi and Michele Rossi
#All rights reserved

if !(test -f synapse-info.xml)
then
	echo "No application info found - please provide the following"
	echo -n "Application ID [integer between 0 and 65535]) "
	read ID
	echo -n "Application Version "
	read version
	echo -n "application name "
	read name
	if !(test $ID -lt 65535 2> /dev/null && test $ID -gt 0 2> /dev/null)
	then
		echo ID must be an integer between 0 and 65535
		exit 1
	fi
	echo "<Application id=\"$ID\">" > synapse-info.xml
	echo $'\t'"<app_name>$name</app_name>" >> synapse-info.xml
	echo  $'\t'"<app_version>$version</app_version>" >> synapse-info.xml
	echo "</Application>" >> synapse-info.xml
fi