#!/bin/bash


d2h="0000"
# FUNCTIONS
dec2hex4R()
{
    d2h="0000"
    h=`echo "obase=16; $1" | bc`
    l=`expr length $h`
    if [ $l -gt 4 ]
    then
        echo -e "\e[31mERR: cant dec2hex4\e[0m"
        exit
    fi
    case $l in
        0 ) d2h="0000";;
        1 ) d2h="000$h";;
        2 ) d2h="00$h";;
        3 ) d2h="0$h";;
        4 ) d2h="$h";;
        * ) echo "bho";;
    esac
    d2h1=`expr substr $d2h 1 2`
    d2h2=`expr substr $d2h 3 2`
    d2h=$d2h2$d2h1
}

dec2hex4()
{
    d2h="0000"
    h=`echo "obase=16; $1" | bc`
    l=`expr length $h`
    if [ $l -gt 4 ]
    then
        echo -e "\e[31mERR: cant dec2hex4\e[0m"
        exit
    fi
    case $l in
        0 ) d2h="0000";;
        1 ) d2h="000$h";;
        2 ) d2h="00$h";;
        3 ) d2h="0$h";;
        4 ) d2h="$h";;
        #should never enter this
        * ) echo -e "\e[31mERR: cant dec2hex4\e[0m";; 
    esac
}

appID="0000"
getAppID()
{
    #MD5S=`md5sum $1`
    #MD5=`expr substr "$MD5S" 1 32`
    #SUMS=`echo $MD5 | sum`
    #appID=`expr substr "$SUMS" 1 5`
    if !(test -f synapse-info.xml)
	then
		echo "No application info found - please give the following"
		echo -n "Application ID [integer between 0 and 65535]) "
		read ID
		echo -n "Application Version "
		read version
		echo -n "application name "
		read name
		if !(test $ID -lt 65535 2> /dev/null && test $ID -gt 0 2> /dev/null)
		then
			echo ID must be an integer between 0 and 65535
			exit 1
		fi
		echo "<Application id=\"$ID\">" > synapse-info.xml
		echo $'\t'"<app_name>$name</app_name>" >> synapse-info.xml
		echo  $'\t'"<app_version>$version</app_version>" >> synapse-info.xml
		echo "</Application>" >> synapse-info.xml
	fi
	appID=$(xmlstarlet sel -t -m  "//Application" -v "@id" synapse-info.xml)
}

#extract bootloader command
if [ -z "$3" ]
then
    echo -e "\e[31mERR: Three parameters required\e[0m"
    exit
fi

## Input parametres
SYNAPSE=$1
IN_FILE=$2
OUT_FILE=$3

# Find size
FILE_SIZE=`objdump -h $IN_FILE | perl -ne '$b{$1}=hex $2 if /^\s*\d+\s*\.(text|data|bss)\s+(\S+)/; END {printf("%i",$b{text}+$b{data});} ' `

echo $SYNAPSE

# bootloader opcodes:
# format        = 1
# store         = 2
# loadID        = 3
# loadPartition = 4

# boot action parser
# format (1)
if [ $SYNAPSE == "format" ]
then
    IHEX_STR=":0A1000000100000000000000000000\r\n"

# storeInExtFlash (2) 
elif [ $SYNAPSE == "storeInExtFlash" ]
then
    getAppID ${IN_FILE}
    dec2hex4R $appID
    HASH_NAME=$d2h
    # convert file size
    dec2hex4R $FILE_SIZE
    # build ihex string
    IHEX_STR=":0A1000000200"$HASH_NAME$d2h"0000000000\r\n"

# loadID (3)
elif [ `expr substr $SYNAPSE 1 6` == "loadID" ]
then
    len=`expr length $SYNAPSE`
    len=`expr $len - 6`
    if [ $len == 4 ]
    then
        LOADID=`expr substr $SYNAPSE 7 $len`
    else
        echo -e "\e[31mERR: loadID must have a ID of 4 char. Partition ID set to 0000\e[0m"
        LOADID="0000"
    fi
    l1=`expr substr $LOADID 1 2`
    l2=`expr substr $LOADID 3 2`
    LOADID=$l2$l1
    # FIXME check if LOADID is a correct hex number
    SYNAPSE=`expr substr $SYNAPSE 1 6`
    # build ihex string
    IHEX_STR=":0A1000000300"$LOADID"00000000000000\r\n"

# loadPartition (4)
elif [ `expr substr $SYNAPSE 1 13` == "loadPartition" ]
then
    len=`expr length $SYNAPSE`
    len=`expr $len - 13`
    if [ $len != 0 ]
    then
        LOADPAR=`expr substr $SYNAPSE 14 $len`
    else
        echo -e "\e[31mERR: load must have a partition index. Partition index set to 1\e[0m"
        LOADPAR=1
    fi
    SYNAPSE=`expr substr $SYNAPSE 1 13`
    dec2hex4R $LOADPAR
    # build ihex string
    IHEX_STR=":0A1000000400"$d2h"00000000000000\r\n"

# setID 
elif [ `expr substr $SYNAPSE 1 5` == "setID" ]
    then
    len=`expr length $SYNAPSE`
    len=`expr $len - 5`
    if [ $len != 0 ]
    then
       LOADPAR=`expr substr $SYNAPSE 6 $len`
    else
       echo -e "\e[31mERR: NO ID specified, set to  1\e[0m"
	LOADPAR=1
    fi
    SYNAPSE=`expr substr $SYNAPSE 1 5`
    dec2hex4R $LOADPAR
    # build ihex string
    IHEX_STR=":0A10000000000000000000"$d2h"0000\r\n"

# none ()
elif [ $SYNAPSE == "none" ]
then
    IHEX_STR=":0A1000000000000000000000000000\r\n"

# getAppID ()
elif [ $SYNAPSE == "getAppID" ]
then
    # write application ID (nothing done on the node)
    getAppID ${IN_FILE}
    dec2hex4 $appID
    echo -e "\e[32mApplicationID: $d2h\e[0m"
    exit

elif [ $SYNAPSE == "getHash" ]
then
    # write application ID (nothing done on the node)
    getAppID ${IN_FILE}
    dec2hex4 $appID
    echo $d2h
    exit
elif [ $SYNAPSE == "getSize" ]
then
    # write application ID (nothing done on the node)
    getAppID ${IN_FILE}
    dec2hex4 $appID
    echo $d2h
    dec2hex4 $FILE_SIZE
    echo $d2h
    exit 
else
    echo -e \
"\e[31m\
execSynapseCommand: command $SYNAPSE not recognized\n\n\
allowed directives:\n\
\tformat \n\tstoreInExtFlash \n\tloadID<decimal ID>\n\tloadPartition<partition number>\n\
\tgetID \n\tgetHash \n\tgetSize\e[0m\n"	 
    exit -1
fi

# write ihex string
echo -e "\e[33m\tSynapse Command: $SYNAPSE => $IHEX_STR \e[0m"
echo -e -n $IHEX_STR >> $OUT_FILE
