%% SIMULAZIONE SISTEMA NON LINEARE
%
% valori nominali degli ingressi
% LTs=2.70629;                          % Reflux
% VBs=3.20629;                          % Boilup
% Ds=0.5;                               % Distillate
% Bs=0.5;                               % Bottoms
% Fs=1.0;                               % Feedrate
% zFs=0.5;                              % Feed composition
% qFs=1.0;                              % Feed liquid fraction
% i primi 41 stati sono le concentrazioni della sostanza volatile
% i secondi 41 sono le masse sui piatti
%
% SIMULAZIONE 1
% inizializzo le concentrazioni a 0.5 e le masse a 0.5 (masse di equil)
% calcolo l'evoluzione libera a ingressi nominali
[t,x]=ode15s('cola4',[0 200],[0.5*ones(41,1);0.5*ones(41,1)]); 
% vengono plottati gli andamenti temporali delle masse
masse=x(:,42:82);
plot(t,masse(:,1:41))
% vengono plottati gli andamenti temporali delle concentrazioni
concentrazioni=x(:,1:41);
plot(t,concentrazioni(:,1:41))
%
% SIMULAZIONE 2
% inizializzo le concentrazioni a zero e le masse a 0.8
% calcolo l'evoluzione libera a ingressi nominali
%
[t,x]=ode15s('cola4',[0 200],[0*ones(41,1);0.8*ones(41,1)]); 
% vengono plottati gli andamenti temporali delle masse
masse=x(:,42:82);
% prima massa (rampa)
plot(t,masse(:,1))
% ultima massa (costante)
plot(t,masse(:,41))
% masse intermedie tendono tutte a costante = 0.5
plot(t,masse(:,2:40))
% vengono plottati gli andamenti temporali delle concentrazioni
concentrazioni=x(:,1:41);
plot(t,concentrazioni(:,1:41))
%
% SIMULAZIONE 3
% inizializzo le concentrazioni a zero e le masse a 0.2
% calcolo l'evoluzione libera a ingressi nominali
% nascono problemi numerici sull'evoluzioni delle concentrazioni
%
[t,x]=ode15s('cola4',[0 200],[0*ones(41,1);0.2*ones(41,1)]); 
% vengono plottati gli andamenti temporali delle masse
masse=x(:,42:82);
% prima massa (rampa)
plot(t,masse(:,1))
% ultima massa (costante)
plot(t,masse(:,41))
% masse intermedie tendono tutte a costante = 0.5
plot(t,masse(:,2:40))
% vengono plottati gli andamenti temporali delle concentrazioni
concentrazioni=x(:,1:41);
plot(t,concentrazioni(:,1:41))
%
%
%% STATI DI EQUILIBRIO 
%
% simulazione del sistema nonlineare CON tutti gli stati iniziali a 0.5
% la simulazione e' lasciata andare per tempi lunghi cosi' da raggiungere
% gli stati di equilibrio = Xinit
[t,x]=ode15s('cola4',[0 20000],[0.5*ones(41,1);0.5*ones(41,1)]); 
lengthx=size(x); Xinit = x(lengthx(1),:)';% Xinit stato di equilibrio
% vengono plottati gli le concentrazioni di equilibrio
plot(Xinit(1:41))
axis([1 41, 0 1])
%
%% EFFETTO DEI DISTURBI
%
% Alimento il sistema nonlineare con i valori equilibrio precedenti 
% in cui l'ingresso F viene aumentato da 1 a 1.01
%
[t,x]=ode15s('cola4_F1',[0 2000],Xinit); 
t0 = t; M1=x(:,42); xB = x(:,1); xD = x(:,41); % 
plot(t0,M1)
axis([0 5, 0.45 0.55])
plot(t0,xB)
plot(t0,xD)
% Alimento il sistema nonlineare con i valori equilibrio precedenti 
% in cui l'ingresso F viene diminuito da 1 a 1-0.001=9.999
%
[t,x]=ode15s('cola4_F1_meno',[0 2000],Xinit); 
t0 = t; M1=x(:,42); xB = x(:,1); xD = x(:,41); % 
plot(t0,M1)
axis([0 5, 0.45 0.55])
plot(t0,xB)
plot(t0,xD)
% Alimento il sistema nonlineare con i valori equilibrio precedenti 
% in cui l'ingresso zF viene diminuito da 0.5 a 0.5-0.1=0.4
%
[t,x]=ode15s('cola4_zF',[0 2000],Xinit); 
t0 = t; M1=x(:,42); xB = x(:,1); xD = x(:,41); % 
plot(t0,M1)
axis([0 5, 0.45 0.55])
plot(t0,xB)
plot(t0,xD)
%
%% EFFETTO DEI DISTURBI NEL SISTEMA CONTROLLATO
%
% Alimento il sistema nonlineare con i valori nominali precedenti 
% qui il sistema nonlineare e' nella cosi' detta configurazione controllata
% LV in cui il MD e MB e' controllato con D e B
% controllo proporzionale
% tilde^D=10*tilde^MD;       % Distillate flow
% tilde^B=10*tilde^MB;       % Bottoms flow  
%
% qui l'ingresso F viene aumentato da 1 a 1.01
% prima si rifanno le simulazioni senza controllo
%
[t,x]=ode15s('cola4_F1',[0 2000],Xinit); 
t0 = t; M1=x(:,42); xB = x(:,1); xD = x(:,41); % 
% poi si fanno le simulazioni con controllo
[t,x]=ode15s('cola_lv_F1',[0 2000],Xinit); 
tlv=t; M1lv=x(:,42); xBlv = x(:,1); xDlv = x(:,41); 
% si campara nei due casi le evoluzioni delle masse MB
plot(tlv,M1lv)
hold on
plot(t0,M1)
axis([0 20, 0.5 0.51])
% si campara nei due casi le evoluzioni di xB
plot(tlv,xBlv)
hold on
plot(t0,xB)
% si campara nei due casi le evoluzioni di xD
plot(tlv,xDlv)
hold on
plot(t0,xD)
%
% qui l'ingresso zF viene diminuito da 0.5 a 0.4
% prima si rifanno le simulazioni senza controllo
%
[t,x]=ode15s('cola4_zF',[0 2000],Xinit); 
t0 = t; M1=x(:,42); xB = x(:,1); xD = x(:,41); % 
% poi si fanno le simulazioni con controllo
[t,x]=ode15s('cola_lv_zF',[0 2000],Xinit); 
tlv=t; M1lv=x(:,42); xBlv = x(:,1); xDlv = x(:,41); 
% si campara nei due casi le evoluzioni delle masse MB
plot(tlv,M1lv)
hold on
plot(t0,M1)
axis([0 20, 0.5 0.51])
% si campara nei due casi le evoluzioni di xB
plot(tlv,xBlv)
hold on
plot(t0,xB)
% si campara nei due casi le evoluzioni di xD
plot(tlv,xDlv)
hold on
plot(t0,xD)
%
%
%% LINEARIZZAZIONE 11
%
% A,B,C,D sono le matrici del sistema linearizzato con 82 stati
% ingressi [L V D B F zF] (qF=1) e uscite [xD xB MD MB] 
% determiniamo autovalori (= poli) ha 2 poli in 0 (doppio integratore)
% e uno dominante in -0.0052= costante di tempo = 193 min
Ls=2.706; Vs=3.206; Ds=0.5; Bs=0.5; Fs=1.0; zFs=0.5;
[A,B,C,D]=cola_linearize('cola4_lin',Xinit',[Ls Vs Ds Bs Fs zFs]);
eig(A)
%% LINEARIZZAZIONE DEL SISTEMA CONTROLLATO 21
%
% In questo caso si linearizza il sistema controllato in configurazione LV
% A,B,C,D sono le matrici del sistema linearizzato con 82 stati
% ingressi [L V F zF] e uscite [xD xB] 
%The linear model for the LV-configurtation (4 inputs, 2 outputs)
Ls=2.70629; Vs=3.20629; Fs=1.0; zFs=0.5;
[A,B,C,D]=cola_linearize('cola_lv_lin',Xinit',[Ls Vs Fs zFs]);
%
%% SCALATURA DEL SISTEMA LINEARIZZATO NON CONTROLLATO 12
% del sistema linearizzato non controllato
% prima rifaccio la linearizzazione del sistema non controllato
% ingressi [LT VB D B] disturbi [F zF] uscite [xD xB MD MB]
Ls=2.706; Vs=3.206; Ds=0.5; Bs=0.5; Fs=1.0; zFs=0.5;
[A,B,C,D]=cola_linearize('cola4_lin',Xinit',[Ls Vs Ds Bs Fs zFs]);
Du = diag([1 1 1 1]);                  % max inputs (scalings)
Dd = diag([ .2 .1]);                   % max disturbances (scalings)
De = diag([0.01 0.01 1 1]);            % max output errors (scalings)
Dud=diag([1 1 1 1 .2 .1]);
As=A;
Bs=B*Dud;
Cs=inv(De)*C;
Ds=inv(De)*D*Dud;
%
%% SCALATURA DEL SISTEMA LINEARIZZATO CONTROLLATO 22
% del sistema controllato linearizzato
% faccio una scalatura dei disturbi [F zF] e della uscite [xD xB]
% disturdi e uscite F/20%F=F/0.2 zF/20%zF=zF/0.1 xB/0.01 xD/0.01
% calcolo le matrici del nuovo sistema
% poi calcolo il guadagno in continua
%
Du = diag([1 1]);                  % max inputs (scalings)
Dd = diag([ .2 .1]);                   % max disturbances (scalings)
De = diag([0.01 0.01]);            % max output errors (scalings)
Dud=diag([1 1 .2 .1]);
As=A;
Bs=B*Dud;
Cs=inv(De)*C;
Ds=inv(De)*D*Dud;
Gcont=-Cs*inv(As)*Bs+Ds
%
%% MODELLO DI ORDINE RIDOTTO
%
% Attraverso il tool sdecomp, sysbal e hankmr  
% si riduce il sistema lineare non-controllato scalato
% da 82 a 8 stati
% ingressi [L V D B F zF] e uscite [xD xB MD MB] 
% CON scalatura su
% disturdi e uscite F/20%F=F/0.2 zF/20%zF=zF/0.1 xB/0.01 xD/0.01
Ar=G4_8(1:8,1:8);
Br=G4_8(1:8,9:14);
Cr=G4_8(9:12,1:8);
Dr=G4_8(9:12,9:14);
eig(Ar)
% applico il controllo delle masse MD e MB
K=zeros(6,4);
K(3,3)=1;
K(4,4)=1;
Ar_cont=Ar-10*Br*K*Cr;
eig(Ar_cont)
Gcont=-Cr*inv(Ar_cont)*Br+Dr
sysr=ss(Ar_cont,Br,Cr,Dr);
Gr=minreal(tf(sysr))
%
%% MODELLO DI ORDINE RIDOTTO
%
% Attraverso un metodo non spiegato si riduce il sistema nonlineare 
% controllato in configurazione LV linearizzato da 82 a 5 stati
% 2 ingressi (L,V) 2 disturbi  (F,zF) e 2 uscite (xd,xb)
% pare (vedi pag 445 di Skogestad) che sia stata fatta una scalatura su
% disturdi e uscite F/20%F=F/0.2 zF/20%zF=zF/0.1 xB/0.01 xD/0.01
% pag 495 Skogestad
A = [ -5.131e-3 0 0 0 0; 0 -7.366e-2 0 0 0; 0 0 -1.829e-1 0 0;
       0 0 0 -4.620e-1  9.895e-1; 0 0 0 -9.895e-1 -4.620e-1]
B = [-.629 .624; .055 -0.172; 0.030 -0.108; 
      -0.186 -0.139; -1.23 -0.056]
C= [-0.7223 -0.5170 0.3386 -0.1633e-1 0.1121;
    -0.8913 0.4728 0.9876 0.8425 0.2186]
D = [ 0 0; 0 0]
Bd = [-0.062 -0.067; 0.131 0.040; 0.022 -0.106; 
     -0.188 0.027; -0.045 0.014]
Gcont=-C*inv(A)*B+D
Gcont_d=-C*inv(A)*Bd+D
sys=ss(A,B,C,D);
G=minreal(tf(sys))
sysd=ss(A,Bd,C,D);
Gd=minreal(tf(sysd))
% calcolo RGA alla pulsazione omega=1
[Mod,fa]=bode(G,1)
1/(1-(Mod(1,2)*Mod(2,1))/(Mod(1,1)*Mod(2,2)))
% poi attraverso il modello simulink cont_PID_colonna.mdl si puo'
% sperimentare un controllo decentalizzato del sistema con 2 controllori
% PID. L'eperimento e' fatto alimentando il sistema con dei disturbi.
%
%% MODELLO DI ORDINE RIDOTTO CON UN SOLO POLO
% Una semplificazione ancora piu' spinta porta ad avere un sistema con
% ingressi [L,V] e uscite [xd,xb] con un solo polo in -1/75 e guadagno in
% continua G0. Nel file simulink controllo_colonna_disacc.mdl si effettua
% un esperimento di controllo con disaccoppiatore valutando l'effetto di
% perturbazioni sul guadagno di ingresso del 20% 
% vedi Skogestad pag 94
G0 = [87.8 -86.4; 108.2 -109.6];C=tf([1],[1 0])*G0^-1;
G=tf([1],[75 1])*G0
Comp=tf([1],[1 0])*G^-1;
L=[1 0;0 1]
L=[1.2 0;0 0.8]